/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.camera.net;

import de.maxhenkel.camera.ImageTools;
import de.maxhenkel.camera.TextureCache;
import de.maxhenkel.camera.net.Message;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageImage
implements Message {
    private UUID uuid;
    private byte[] image;

    public MessageImage() {
    }

    public MessageImage(UUID uuid, byte[] image) {
        this.uuid = uuid;
        this.image = image;
    }

    @Override
    public void executeServerSide(NetworkEvent.Context context) {
    }

    @Override
    public void executeClientSide(NetworkEvent.Context context) {
        try {
            final BufferedImage img = ImageTools.fromBytes(this.image);
            Minecraft.func_71410_x().func_152344_a(new Runnable(){

                @Override
                public void run() {
                    TextureCache.instance().addImage(MessageImage.this.uuid, img);
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public MessageImage fromBytes(PacketBuffer buf) {
        long l1 = buf.readLong();
        long l2 = buf.readLong();
        this.uuid = new UUID(l1, l2);
        int length = buf.readInt();
        this.image = new byte[length];
        buf.readBytes(this.image);
        return this;
    }

    @Override
    public void toBytes(PacketBuffer buf) {
        buf.writeLong(this.uuid.getMostSignificantBits());
        buf.writeLong(this.uuid.getLeastSignificantBits());
        buf.writeInt(this.image.length);
        buf.writeBytes(this.image);
    }
}

