/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.camera.net;

import de.maxhenkel.camera.Main;
import de.maxhenkel.camera.net.Message;
import java.util.UUID;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessagePartialImage
implements Message {
    private UUID imgUUID;
    private int offset;
    private int length;
    private byte[] bytes;

    public MessagePartialImage() {
    }

    public MessagePartialImage(UUID imgUUID, int offset, int length, byte[] bytes) {
        this.imgUUID = imgUUID;
        this.offset = offset;
        this.length = length;
        this.bytes = bytes;
    }

    @Override
    public void executeServerSide(NetworkEvent.Context context) {
        Main.PACKET_MANAGER.addBytes(context.getSender(), this.imgUUID, this.offset, this.length, this.bytes);
    }

    @Override
    public void executeClientSide(NetworkEvent.Context context) {
    }

    public MessagePartialImage fromBytes(PacketBuffer buf) {
        long l1 = buf.readLong();
        long l2 = buf.readLong();
        this.imgUUID = new UUID(l1, l2);
        this.offset = buf.readInt();
        this.length = buf.readInt();
        int length = buf.readInt();
        this.bytes = new byte[length];
        buf.readBytes(this.bytes);
        return this;
    }

    @Override
    public void toBytes(PacketBuffer buf) {
        buf.writeLong(this.imgUUID.getMostSignificantBits());
        buf.writeLong(this.imgUUID.getLeastSignificantBits());
        buf.writeInt(this.offset);
        buf.writeInt(this.length);
        buf.writeInt(this.bytes.length);
        buf.writeBytes(this.bytes);
    }
}

