/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.camera.net;

import de.maxhenkel.camera.ImageTools;
import de.maxhenkel.camera.Main;
import de.maxhenkel.camera.net.Message;
import de.maxhenkel.camera.net.MessageImage;
import de.maxhenkel.camera.net.MessageImageUnavailable;
import java.io.IOException;
import java.util.UUID;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageRequestImage
implements Message {
    private UUID imgUUID;

    public MessageRequestImage() {
    }

    public MessageRequestImage(UUID imgUUID) {
        this.imgUUID = imgUUID;
    }

    @Override
    public void executeServerSide(NetworkEvent.Context context) {
        try {
            byte[] data = ImageTools.toBytes(Main.PACKET_MANAGER.getExistingImage(context.getSender(), this.imgUUID));
            Main.SIMPLE_CHANNEL.reply((Object)new MessageImage(this.imgUUID, data), context);
        }
        catch (IOException e) {
            e.printStackTrace();
            Main.SIMPLE_CHANNEL.reply((Object)new MessageImageUnavailable(this.imgUUID), context);
        }
    }

    @Override
    public void executeClientSide(NetworkEvent.Context context) {
    }

    public MessageRequestImage fromBytes(PacketBuffer buf) {
        long l1 = buf.readLong();
        long l2 = buf.readLong();
        this.imgUUID = new UUID(l1, l2);
        return this;
    }

    @Override
    public void toBytes(PacketBuffer buf) {
        buf.writeLong(this.imgUUID.getMostSignificantBits());
        buf.writeLong(this.imgUUID.getLeastSignificantBits());
    }
}

