/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.camera;

import com.mojang.blaze3d.platform.GlStateManager;
import de.maxhenkel.camera.Main;
import de.maxhenkel.camera.Shaders;
import de.maxhenkel.camera.items.CameraItem;
import de.maxhenkel.camera.net.MessageDisableCameraMode;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.IngameMenuScreen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(modid="camera", value={Dist.CLIENT})
public class ClientEvents {
    private static final ResourceLocation VIEWFINDER = new ResourceLocation("camera", "textures/gui/viewfinder_overlay.png");
    private static final ResourceLocation ZOOM = new ResourceLocation("camera", "textures/gui/zoom.png");
    public static final double MAX_FOV = 90.0;
    public static final double MIN_FOV = 5.0;
    private Minecraft mc = Minecraft.func_71410_x();
    private boolean inCameraMode = false;
    private double fov = 0.0;
    private ResourceLocation currentShader;

    @SubscribeEvent
    public void renderOverlay(RenderGameOverlayEvent.Pre event) {
        if (event.getType().equals((Object)RenderGameOverlayEvent.ElementType.ALL)) {
            return;
        }
        this.inCameraMode = this.isInCameraMode();
        if (!this.inCameraMode) {
            this.setShader(null);
            return;
        }
        event.setCanceled(true);
        if (!event.getType().equals((Object)RenderGameOverlayEvent.ElementType.EXPERIENCE)) {
            return;
        }
        this.mc.field_71474_y.field_74320_O = 0;
        this.setShader(this.getShader((PlayerEntity)this.mc.field_71439_g));
        this.drawViewFinder();
        this.drawZoom(this.getFOVPercentage());
    }

    private void drawViewFinder() {
        float hnew;
        float wnew;
        GlStateManager.pushMatrix();
        this.mc.func_110434_K().func_110577_a(VIEWFINDER);
        float imageWidth = 192.0f;
        float imageHeight = 100.0f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        float ws = this.mc.field_195558_d.func_198107_o();
        float hs = this.mc.field_195558_d.func_198087_p();
        float rs = ws / hs;
        float ri = imageWidth / imageHeight;
        if (rs > ri) {
            wnew = imageWidth * hs / imageHeight;
            hnew = hs;
        } else {
            wnew = ws;
            hnew = imageHeight * ws / imageWidth;
        }
        float top = (hs - hnew) / 2.0f;
        float left = (ws - wnew) / 2.0f;
        buffer.func_181662_b((double)left, (double)top, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        buffer.func_181662_b((double)left, (double)(top + hnew), 0.0).func_187315_a(0.0, 1.0).func_181675_d();
        buffer.func_181662_b((double)(left + wnew), (double)(top + hnew), 0.0).func_187315_a(1.0, 1.0).func_181675_d();
        buffer.func_181662_b((double)(left + wnew), (double)top, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.popMatrix();
    }

    private void drawZoom(double percent) {
        GlStateManager.pushMatrix();
        this.mc.func_110434_K().func_110577_a(ZOOM);
        int zoomWidth = 112;
        int zoomHeight = 20;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        int width = this.mc.field_195558_d.func_198107_o();
        int height = this.mc.field_195558_d.func_198087_p();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        int left = (width - zoomWidth) / 2;
        int top = height / 40;
        buffer.func_181662_b((double)left, (double)top, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        buffer.func_181662_b((double)left, (double)(top + zoomHeight / 2), 0.0).func_187315_a(0.0, 0.5).func_181675_d();
        buffer.func_181662_b((double)(left + zoomWidth), (double)(top + zoomHeight / 2), 0.0).func_187315_a(1.0, 0.5).func_181675_d();
        buffer.func_181662_b((double)(left + zoomWidth), (double)top, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
        int percWidth = (int)(Math.max(Math.min(percent, 1.0), 0.0) * (double)zoomWidth);
        buffer.func_181662_b((double)left, (double)top, 0.0).func_187315_a(0.0, 0.5).func_181675_d();
        buffer.func_181662_b((double)left, (double)(top + zoomHeight / 2), 0.0).func_187315_a(0.0, 1.0).func_181675_d();
        buffer.func_181662_b((double)(left + percWidth), (double)(top + zoomHeight / 2), 0.0).func_187315_a(1.0 * percent, 1.0).func_181675_d();
        buffer.func_181662_b((double)(left + percWidth), (double)top, 0.0).func_187315_a(1.0 * percent, 0.5).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.popMatrix();
    }

    @SubscribeEvent
    public void renderHand(RenderHandEvent event) {
        if (this.inCameraMode) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onGuiOpen(GuiOpenEvent event) {
        if (this.inCameraMode && event.getGui() instanceof IngameMenuScreen) {
            Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageDisableCameraMode());
            event.setCanceled(true);
        }
    }

    private ResourceLocation getShader(PlayerEntity player) {
        ItemStack stack = this.mc.field_71439_g.func_184614_ca();
        if (!stack.func_77973_b().equals((Object)Main.CAMERA)) {
            return null;
        }
        return Shaders.getShader(Main.CAMERA.getShader(stack));
    }

    private void setShader(ResourceLocation shader) {
        if (shader == null) {
            if (this.currentShader != null) {
                this.mc.field_71460_t.func_181022_b();
            }
        } else if (!shader.equals((Object)this.currentShader)) {
            try {
                this.mc.field_71460_t.func_175069_a(shader);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.currentShader = shader;
    }

    @SubscribeEvent
    public void renderPlayer(RenderPlayerEvent.Pre event) {
        PlayerEntity player = event.getPlayer();
        if (player == this.mc.field_71439_g) {
            return;
        }
        for (Hand hand : Hand.values()) {
            ItemStack stack = player.func_184586_b(hand);
            if (!(stack.func_77973_b() instanceof CameraItem) || !Main.CAMERA.isActive(stack)) continue;
            player.func_184598_c(hand);
        }
    }

    @SubscribeEvent
    public void renderPlayer(RenderPlayerEvent.Post event) {
        PlayerEntity player = event.getPlayer();
        if (player == this.mc.field_71439_g) {
            return;
        }
        if (!this.inCameraMode) {
            return;
        }
        event.getPlayer().func_184602_cy();
    }

    @SubscribeEvent
    public void onMouseEvent(InputEvent.MouseScrollEvent event) {
        if (event.getScrollDelta() == 0.0) {
            return;
        }
        if (!this.inCameraMode) {
            return;
        }
        this.fov = event.getScrollDelta() < 0.0 ? Math.min(this.fov + 5.0, 90.0) : Math.max(this.fov - 5.0, 5.0);
        event.setCanceled(true);
    }

    @SubscribeEvent
    public void onFOVModifierEvent(EntityViewRenderEvent.FOVModifier event) {
        if (!this.inCameraMode) {
            this.fov = event.getFOV();
            return;
        }
        this.mc.field_71439_g.field_70163_u += 1.0E-9;
        event.setFOV(this.fov);
    }

    public double getFOVPercentage() {
        return 1.0 - (this.fov - 5.0) / 85.0;
    }

    private ItemStack getActiveCamera() {
        if (this.mc.field_71439_g == null) {
            return null;
        }
        for (Hand hand : Hand.values()) {
            ItemStack stack = this.mc.field_71439_g.func_184586_b(hand);
            if (!stack.func_77973_b().equals((Object)Main.CAMERA) || !Main.CAMERA.isActive(stack)) continue;
            return stack;
        }
        return null;
    }

    private boolean isInCameraMode() {
        return this.getActiveCamera() != null;
    }
}

