/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.camera;

import de.maxhenkel.camera.ItemTools;
import java.text.SimpleDateFormat;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class Config {
    public static final ServerConfig SERVER;
    public static final ForgeConfigSpec SERVER_SPEC;
    public static final ClientConfig CLIENT;
    public static final ForgeConfigSpec CLIENT_SPEC;
    private static ItemStack cachedStack;
    private static SimpleDateFormat cachedDateFormat;

    private static SimpleDateFormat getDateFormat(String format) {
        return new SimpleDateFormat(format);
    }

    private static ItemStack getItemStack(String stack) {
        return ItemTools.deserializeItemStack(stack);
    }

    public static ItemStack getConsumingStack() {
        if (cachedStack == null) {
            cachedStack = Config.getItemStack((String)Config.SERVER.CAMERA_CONSUME_ITEM.get());
        }
        return cachedStack;
    }

    public static SimpleDateFormat getImageDateFormat() {
        if (cachedDateFormat == null) {
            cachedDateFormat = Config.getDateFormat((String)Config.CLIENT.IMAGE_DATE_FORMAT.get());
        }
        return cachedDateFormat;
    }

    public static void onServerConfigUpdate() {
        cachedStack = null;
    }

    public static void onClientConfigUpdate() {
        cachedDateFormat = null;
    }

    static {
        Pair specPairServer = new ForgeConfigSpec.Builder().configure(ServerConfig::new);
        SERVER_SPEC = (ForgeConfigSpec)specPairServer.getRight();
        SERVER = (ServerConfig)specPairServer.getLeft();
        Pair specPairClient = new ForgeConfigSpec.Builder().configure(ClientConfig::new);
        CLIENT_SPEC = (ForgeConfigSpec)specPairClient.getRight();
        CLIENT = (ClientConfig)specPairClient.getLeft();
    }

    public static class ClientConfig {
        public ForgeConfigSpec.ConfigValue<String> IMAGE_DATE_FORMAT;
        public ForgeConfigSpec.ConfigValue<String> LAST_IMAGE_PATH;

        public ClientConfig(ForgeConfigSpec.Builder builder) {
            this.IMAGE_DATE_FORMAT = builder.comment("The format the date will be displayed on the image").define("image_date_format", (Object)"MM/dd/yyyy HH:mm");
            this.LAST_IMAGE_PATH = builder.define("last_image_path", (Object)"");
        }
    }

    public static class ServerConfig {
        public ForgeConfigSpec.IntValue IMAGE_COOLDOWN;
        public ForgeConfigSpec.ConfigValue<String> CAMERA_CONSUME_ITEM;
        public ForgeConfigSpec.IntValue MAX_IMAGE_SIZE;

        public ServerConfig(ForgeConfigSpec.Builder builder) {
            this.IMAGE_COOLDOWN = builder.comment("The time in milliseconds the camera will be on cooldown after taking an image").defineInRange("image_cooldown", 5000, 100, Integer.MAX_VALUE);
            this.CAMERA_CONSUME_ITEM = builder.comment("The Item that is consumed when taking an image").define("camera_consume_item", (Object)ItemTools.serializeItemStack(new ItemStack((IItemProvider)Items.field_151121_aF, 1)));
            this.MAX_IMAGE_SIZE = builder.comment(new String[]{"The maximum size of an image in bytes when transferred to the server", "Higher values mean more delay/lag between taking an image and getting it into your inventory"}).defineInRange("max_image_size", 200000, 50000, 1000000);
        }
    }
}

