/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.camera;

import de.maxhenkel.camera.ClientEvents;
import de.maxhenkel.camera.Config;
import de.maxhenkel.camera.ImageTaker;
import de.maxhenkel.camera.ModSounds;
import de.maxhenkel.camera.RecipeImageCloning;
import de.maxhenkel.camera.ServerEvents;
import de.maxhenkel.camera.entities.ImageEntity;
import de.maxhenkel.camera.entities.ImageRenderer;
import de.maxhenkel.camera.gui.AlbumInventoryScreen;
import de.maxhenkel.camera.gui.ContainerAlbumInventory;
import de.maxhenkel.camera.items.AlbumItem;
import de.maxhenkel.camera.items.CameraItem;
import de.maxhenkel.camera.items.ImageFrameItem;
import de.maxhenkel.camera.items.ItemImage;
import de.maxhenkel.camera.net.MessageDisableCameraMode;
import de.maxhenkel.camera.net.MessageImage;
import de.maxhenkel.camera.net.MessageImageUnavailable;
import de.maxhenkel.camera.net.MessagePartialImage;
import de.maxhenkel.camera.net.MessageRequestImage;
import de.maxhenkel.camera.net.MessageRequestUploadCustomImage;
import de.maxhenkel.camera.net.MessageResizeFrame;
import de.maxhenkel.camera.net.MessageSetShader;
import de.maxhenkel.camera.net.MessageTakeImage;
import de.maxhenkel.camera.net.MessageUploadCustomImage;
import de.maxhenkel.camera.net.PacketManager;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.SpecialRecipeSerializer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.ObjectHolder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="camera")
public class Main {
    public static final String MODID = "camera";
    public static final Logger LOGGER = LogManager.getLogger((String)"camera");
    public static SimpleChannel SIMPLE_CHANNEL;
    public static PacketManager PACKET_MANAGER;
    public static SpecialRecipeSerializer<RecipeImageCloning> CRAFTING_SPECIAL_IMAGE_CLONING;
    @ObjectHolder(value="camera:image_frame")
    public static ImageFrameItem FRAME_ITEM;
    @ObjectHolder(value="camera:camera")
    public static CameraItem CAMERA;
    @ObjectHolder(value="camera:image")
    public static ItemImage IMAGE;
    @ObjectHolder(value="camera:album")
    public static AlbumItem ALBUM;
    @ObjectHolder(value="camera:album_inventory")
    public static ContainerType ALBUM_INVENTORY_CONTAINER;
    @ObjectHolder(value="camera:image_frame")
    public static EntityType<ImageEntity> IMAGE_ENTITY_TYPE;
    @OnlyIn(value=Dist.CLIENT)
    public static KeyBinding KEY_NEXT;
    @OnlyIn(value=Dist.CLIENT)
    public static KeyBinding KEY_PREVIOUS;

    public Main() {
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(Item.class, this::registerItems);
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(SoundEvent.class, this::registerSounds);
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(EntityType.class, this::registerEntities);
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(ContainerType.class, this::registerContainers);
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(IRecipeSerializer.class, this::registerRecipes);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::commonSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::configEvent);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, Config.SERVER_SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, Config.CLIENT_SPEC);
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> this.clientStart());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientStart() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientSetup);
        RenderingRegistry.registerEntityRenderingHandler(ImageEntity.class, manager -> new ImageRenderer(manager));
    }

    @SubscribeEvent
    public void configEvent(ModConfig.ModConfigEvent event) {
        if (event.getConfig().getType() == ModConfig.Type.SERVER) {
            Config.onServerConfigUpdate();
        } else if (event.getConfig().getType() == ModConfig.Type.CLIENT) {
            Config.onClientConfigUpdate();
        }
    }

    @SubscribeEvent
    public void commonSetup(FMLCommonSetupEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new ServerEvents());
        SIMPLE_CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation(MODID, "default"), () -> "1.0.0", s -> true, s -> true);
        PACKET_MANAGER = new PacketManager();
        SIMPLE_CHANNEL.registerMessage(0, MessagePartialImage.class, (msg, buf) -> msg.toBytes((PacketBuffer)buf), buf -> new MessagePartialImage().fromBytes((PacketBuffer)buf), (msg, fun) -> msg.executeServerSide((NetworkEvent.Context)fun.get()));
        SIMPLE_CHANNEL.registerMessage(1, MessageTakeImage.class, (msg, buf) -> msg.toBytes((PacketBuffer)buf), buf -> new MessageTakeImage().fromBytes((PacketBuffer)buf), (msg, fun) -> msg.executeClientSide((NetworkEvent.Context)fun.get()));
        SIMPLE_CHANNEL.registerMessage(2, MessageRequestImage.class, (msg, buf) -> msg.toBytes((PacketBuffer)buf), buf -> new MessageRequestImage().fromBytes((PacketBuffer)buf), (msg, fun) -> msg.executeServerSide((NetworkEvent.Context)fun.get()));
        SIMPLE_CHANNEL.registerMessage(3, MessageImage.class, (msg, buf) -> msg.toBytes((PacketBuffer)buf), buf -> new MessageImage().fromBytes((PacketBuffer)buf), (msg, fun) -> msg.executeClientSide((NetworkEvent.Context)fun.get()));
        SIMPLE_CHANNEL.registerMessage(4, MessageImageUnavailable.class, (msg, buf) -> msg.toBytes((PacketBuffer)buf), buf -> new MessageImageUnavailable().fromBytes((PacketBuffer)buf), (msg, fun) -> msg.executeClientSide((NetworkEvent.Context)fun.get()));
        SIMPLE_CHANNEL.registerMessage(5, MessageSetShader.class, (msg, buf) -> msg.toBytes((PacketBuffer)buf), buf -> new MessageSetShader().fromBytes((PacketBuffer)buf), (msg, fun) -> msg.executeServerSide((NetworkEvent.Context)fun.get()));
        SIMPLE_CHANNEL.registerMessage(6, MessageDisableCameraMode.class, (msg, buf) -> msg.toBytes((PacketBuffer)buf), buf -> new MessageDisableCameraMode().fromBytes((PacketBuffer)buf), (msg, fun) -> msg.executeServerSide((NetworkEvent.Context)fun.get()));
        SIMPLE_CHANNEL.registerMessage(7, MessageResizeFrame.class, (msg, buf) -> msg.toBytes((PacketBuffer)buf), buf -> new MessageResizeFrame().fromBytes((PacketBuffer)buf), (msg, fun) -> msg.executeServerSide((NetworkEvent.Context)fun.get()));
        SIMPLE_CHANNEL.registerMessage(8, MessageRequestUploadCustomImage.class, (msg, buf) -> msg.toBytes((PacketBuffer)buf), buf -> new MessageRequestUploadCustomImage().fromBytes((PacketBuffer)buf), (msg, fun) -> msg.executeServerSide((NetworkEvent.Context)fun.get()));
        SIMPLE_CHANNEL.registerMessage(9, MessageUploadCustomImage.class, (msg, buf) -> msg.toBytes((PacketBuffer)buf), buf -> new MessageUploadCustomImage().fromBytes((PacketBuffer)buf), (msg, fun) -> msg.executeClientSide((NetworkEvent.Context)fun.get()));
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void clientSetup(FMLClientSetupEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new ImageTaker());
        MinecraftForge.EVENT_BUS.register((Object)new ClientEvents());
        KEY_NEXT = new KeyBinding("key.next_image", 264, "key.categories.misc");
        ClientRegistry.registerKeyBinding((KeyBinding)KEY_NEXT);
        KEY_PREVIOUS = new KeyBinding("key.previous_image", 265, "key.categories.misc");
        ClientRegistry.registerKeyBinding((KeyBinding)KEY_PREVIOUS);
        ScreenManager.IScreenFactory factory = (container, playerInventory, name) -> new AlbumInventoryScreen(playerInventory, (ContainerAlbumInventory)container, name);
        ScreenManager.func_216911_a((ContainerType)ALBUM_INVENTORY_CONTAINER, (ScreenManager.IScreenFactory)factory);
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> event) {
        Item[] itemArray = new Item[4];
        FRAME_ITEM = new ImageFrameItem();
        itemArray[0] = FRAME_ITEM;
        CAMERA = new CameraItem();
        itemArray[1] = CAMERA;
        IMAGE = new ItemImage();
        itemArray[2] = IMAGE;
        ALBUM = new AlbumItem();
        itemArray[3] = ALBUM;
        event.getRegistry().registerAll((IForgeRegistryEntry[])itemArray);
    }

    @SubscribeEvent
    public void registerSounds(RegistryEvent.Register<SoundEvent> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new SoundEvent[]{ModSounds.TAKE_IMAGE});
    }

    @SubscribeEvent
    public void registerEntities(RegistryEvent.Register<EntityType<?>> event) {
        IMAGE_ENTITY_TYPE = EntityType.Builder.func_220322_a(ImageEntity::new, (EntityClassification)EntityClassification.MISC).setTrackingRange(256).setUpdateInterval(20).setShouldReceiveVelocityUpdates(false).func_220321_a(1.0f, 1.0f).setCustomClientFactory((spawnEntity, world) -> new ImageEntity((World)world)).func_206830_a("camera:image_frame");
        IMAGE_ENTITY_TYPE.setRegistryName(new ResourceLocation(MODID, "image_frame"));
        event.getRegistry().register(IMAGE_ENTITY_TYPE);
    }

    @SubscribeEvent
    public void registerContainers(RegistryEvent.Register<ContainerType<?>> event) {
        ALBUM_INVENTORY_CONTAINER = new ContainerType(ContainerAlbumInventory::new);
        ALBUM_INVENTORY_CONTAINER.setRegistryName(new ResourceLocation(MODID, "album_inventory"));
        event.getRegistry().register((IForgeRegistryEntry)ALBUM_INVENTORY_CONTAINER);
    }

    @SubscribeEvent
    public void registerRecipes(RegistryEvent.Register<IRecipeSerializer<?>> event) {
        CRAFTING_SPECIAL_IMAGE_CLONING = new SpecialRecipeSerializer(RecipeImageCloning::new);
        CRAFTING_SPECIAL_IMAGE_CLONING.setRegistryName(MODID, "crafting_special_imagecloning");
        event.getRegistry().register(CRAFTING_SPECIAL_IMAGE_CLONING);
    }
}

