/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.camera.entities;

import com.mojang.blaze3d.platform.GlStateManager;
import de.maxhenkel.camera.TextureCache;
import de.maxhenkel.camera.Tools;
import de.maxhenkel.camera.entities.ImageEntity;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;

public class ImageRenderer
extends EntityRenderer<ImageEntity> {
    private static final ResourceLocation DEFAULT_IMAGE = new ResourceLocation("camera", "textures/images/default_image.png");
    private static final ResourceLocation EMPTY_IMAGE = new ResourceLocation("camera", "textures/images/empty_image.png");
    private static final ResourceLocation FRAME_SIDE = new ResourceLocation("camera", "textures/images/frame_side.png");
    private static final ResourceLocation FRAME_BACK = new ResourceLocation("camera", "textures/images/frame_back.png");
    private static final double THICKNESS = 0.0625;
    private Minecraft mc = Minecraft.func_71410_x();

    public ImageRenderer(EntityRendererManager renderManager) {
        super(renderManager);
    }

    public void doRender(ImageEntity entity, double x, double y, double z, float entityYaw, float partialTicks) {
        float ratioY;
        float ratioX;
        float imageRatio = 1.0f;
        boolean stretch = true;
        ResourceLocation resourceLocation = EMPTY_IMAGE;
        UUID imageUUID = entity.getImageUUID();
        if (imageUUID != null) {
            ResourceLocation rl = TextureCache.instance().getImage(imageUUID);
            if (rl != null) {
                resourceLocation = rl;
                NativeImage image = TextureCache.instance().getNativeImage(imageUUID);
                imageRatio = (float)image.func_195702_a() / (float)image.func_195714_b();
                stretch = false;
            } else {
                resourceLocation = DEFAULT_IMAGE;
                imageRatio = 1.5f;
                stretch = false;
            }
        }
        GlStateManager.pushMatrix();
        GlStateManager.translated((double)(x - 0.5), (double)y, (double)(z - 0.5));
        GlStateManager.disableLighting();
        GlStateManager.disableBlend();
        Direction facing = entity.getFacing();
        double width = entity.getFrameWidth();
        double height = entity.getFrameHeight();
        ImageRenderer.rotate(facing);
        this.func_110776_a(resourceLocation);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        float frameRatio = (float)(width / height);
        float ratio = imageRatio / frameRatio;
        if (stretch) {
            ratioX = 0.0f;
            ratioY = 0.0f;
        } else {
            if (ratio >= 1.0f) {
                ratioY = (1.0f - 1.0f / ratio) / 2.0f;
                ratioX = 0.0f;
            } else {
                ratioX = (1.0f - ratio) / 2.0f;
                ratioY = 0.0f;
            }
            ratioX = (float)((double)ratioX * width);
            ratioY = (float)((double)ratioY * height);
        }
        buffer.func_181662_b(0.0 + (double)ratioX, (double)ratioY, 0.0625).func_187315_a(0.0, 1.0).func_181675_d();
        buffer.func_181662_b(width - (double)ratioX, (double)ratioY, 0.0625).func_187315_a(1.0, 1.0).func_181675_d();
        buffer.func_181662_b(width - (double)ratioX, height - (double)ratioY, 0.0625).func_187315_a(1.0, 0.0).func_181675_d();
        buffer.func_181662_b(0.0 + (double)ratioX, height - (double)ratioY, 0.0625).func_187315_a(0.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
        this.func_110776_a(FRAME_SIDE);
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_181662_b(0.0 + (double)ratioX, 0.0 + (double)ratioY, 0.0).func_187315_a(1.0, 0.0 + (double)ratioY).func_181675_d();
        buffer.func_181662_b(0.0 + (double)ratioX, 0.0 + (double)ratioY, 0.0625).func_187315_a(0.9375, 0.0 + (double)ratioY).func_181675_d();
        buffer.func_181662_b(0.0 + (double)ratioX, height - (double)ratioY, 0.0625).func_187315_a(0.9375, 1.0 - (double)ratioY).func_181675_d();
        buffer.func_181662_b(0.0 + (double)ratioX, height - (double)ratioY, 0.0).func_187315_a(1.0, 1.0 - (double)ratioY).func_181675_d();
        buffer.func_181662_b(width - (double)ratioX, 0.0 + (double)ratioY, 0.0).func_187315_a(0.0, 0.0 + (double)ratioY).func_181675_d();
        buffer.func_181662_b(width - (double)ratioX, height - (double)ratioY, 0.0).func_187315_a(0.0, 1.0 - (double)ratioY).func_181675_d();
        buffer.func_181662_b(width - (double)ratioX, height - (double)ratioY, 0.0625).func_187315_a(0.0625, 1.0 - (double)ratioY).func_181675_d();
        buffer.func_181662_b(width - (double)ratioX, 0.0 + (double)ratioY, 0.0625).func_187315_a(0.0625, 0.0 + (double)ratioY).func_181675_d();
        buffer.func_181662_b(0.0 + (double)ratioX, height - (double)ratioY, 0.0).func_187315_a(0.0 + (double)ratioX, 1.0).func_181675_d();
        buffer.func_181662_b(0.0 + (double)ratioX, height - (double)ratioY, 0.0625).func_187315_a(0.0 + (double)ratioX, 0.9375).func_181675_d();
        buffer.func_181662_b(width - (double)ratioX, height - (double)ratioY, 0.0625).func_187315_a(1.0 - (double)ratioX, 0.9375).func_181675_d();
        buffer.func_181662_b(width - (double)ratioX, height - (double)ratioY, 0.0).func_187315_a(1.0 - (double)ratioX, 1.0).func_181675_d();
        buffer.func_181662_b(0.0 + (double)ratioX, 0.0 + (double)ratioY, 0.0).func_187315_a(0.0 + (double)ratioX, 0.0).func_181675_d();
        buffer.func_181662_b(width - (double)ratioX, 0.0 + (double)ratioY, 0.0).func_187315_a(1.0 - (double)ratioX, 0.0).func_181675_d();
        buffer.func_181662_b(width - (double)ratioX, 0.0 + (double)ratioY, 0.0625).func_187315_a(1.0 - (double)ratioX, 0.0625).func_181675_d();
        buffer.func_181662_b(0.0 + (double)ratioX, 0.0 + (double)ratioY, 0.0625).func_187315_a(0.0 + (double)ratioX, 0.0625).func_181675_d();
        tessellator.func_78381_a();
        this.func_110776_a(FRAME_BACK);
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_181662_b(width - (double)ratioX, 0.0 + (double)ratioY, 0.0).func_187315_a(1.0 - (double)ratioX, 0.0 + (double)ratioY).func_181675_d();
        buffer.func_181662_b(0.0 + (double)ratioX, 0.0 + (double)ratioY, 0.0).func_187315_a(0.0 + (double)ratioX, 0.0 + (double)ratioY).func_181675_d();
        buffer.func_181662_b(0.0 + (double)ratioX, height - (double)ratioY, 0.0).func_187315_a(0.0 + (double)ratioX, 1.0 - (double)ratioY).func_181675_d();
        buffer.func_181662_b(width - (double)ratioX, height - (double)ratioY, 0.0).func_187315_a(1.0 - (double)ratioX, 1.0 - (double)ratioY).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.enableLighting();
        GlStateManager.disableBlend();
        GlStateManager.popMatrix();
        this.renderBoundingBox(entity, x, y, z);
        super.func_76986_a((Entity)entity, x, y, z, entityYaw, partialTicks);
    }

    private void renderBoundingBox(ImageEntity entity, double x, double y, double z) {
        if (Tools.getEntityLookingAt() != entity) {
            return;
        }
        if (this.mc.field_71474_y.field_74319_N) {
            return;
        }
        GlStateManager.depthMask((boolean)false);
        GlStateManager.disableTexture();
        GlStateManager.disableLighting();
        GlStateManager.disableCull();
        GlStateManager.disableBlend();
        AxisAlignedBB axisalignedbb = entity.func_174813_aQ();
        WorldRenderer.func_189694_a((double)(axisalignedbb.field_72340_a - entity.field_70165_t + x), (double)(axisalignedbb.field_72338_b - entity.field_70163_u + y), (double)(axisalignedbb.field_72339_c - entity.field_70161_v + z), (double)(axisalignedbb.field_72336_d - entity.field_70165_t + x), (double)(axisalignedbb.field_72337_e - entity.field_70163_u + y), (double)(axisalignedbb.field_72334_f - entity.field_70161_v + z), (float)0.25f, (float)0.25f, (float)0.25f, (float)1.0f);
        GlStateManager.enableTexture();
        GlStateManager.enableLighting();
        GlStateManager.enableCull();
        GlStateManager.disableBlend();
        GlStateManager.depthMask((boolean)true);
    }

    public static void rotate(Direction facing) {
        switch (facing) {
            case NORTH: {
                GlStateManager.translated((double)1.0, (double)0.0, (double)1.0);
                GlStateManager.rotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case SOUTH: {
                break;
            }
            case EAST: {
                GlStateManager.translated((double)0.0, (double)0.0, (double)1.0);
                GlStateManager.rotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case WEST: {
                GlStateManager.translated((double)1.0, (double)0.0, (double)0.0);
                GlStateManager.rotatef((float)270.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            }
        }
    }

    @Nullable
    protected ResourceLocation getEntityTexture(ImageEntity entity) {
        return DEFAULT_IMAGE;
    }
}

