/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.camera.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import de.maxhenkel.camera.ClientImageUploadManager;
import de.maxhenkel.camera.ImageTools;
import de.maxhenkel.camera.Main;
import de.maxhenkel.camera.Shaders;
import de.maxhenkel.camera.gui.DummyContainer;
import de.maxhenkel.camera.net.MessageRequestUploadCustomImage;
import de.maxhenkel.camera.net.MessageSetShader;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.UUID;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class CameraScreen
extends ContainerScreen {
    private static final ResourceLocation CAMERA_TEXTURE = new ResourceLocation("camera", "textures/gui/camera.png");
    private static final int FONT_COLOR = 0x404040;
    private int index = 0;

    public CameraScreen(String currentShader) {
        super((Container)new DummyContainer(), null, (ITextComponent)new TranslationTextComponent("gui.camera.title", new Object[0]));
        this.field_146999_f = 248;
        this.field_147000_g = 109;
        for (int i = 0; i < Shaders.SHADER_LIST.size(); ++i) {
            String s = Shaders.SHADER_LIST.get(i);
            if (currentShader == null) {
                if (!s.equals("none")) continue;
                this.index = i;
                break;
            }
            if (!s.equals(currentShader)) continue;
            this.index = i;
            break;
        }
    }

    protected void init() {
        super.init();
        this.buttons.clear();
        int padding = 10;
        int buttonWidth = 70;
        int buttonHeight = 20;
        this.addButton((Widget)new Button(this.field_147003_i + padding, this.field_147009_r + this.field_147000_g / 2 - buttonHeight / 2, buttonWidth, buttonHeight, new TranslationTextComponent("button.camera.prev", new Object[0]).func_150254_d(), button -> {
            --this.index;
            if (this.index < 0) {
                this.index = Shaders.SHADER_LIST.size() - 1;
            }
            this.sendShader();
        }));
        this.addButton((Widget)new Button(this.field_147003_i + this.field_146999_f - buttonWidth - padding, this.field_147009_r + this.field_147000_g / 2 - buttonHeight / 2, buttonWidth, buttonHeight, new TranslationTextComponent("button.camera.next", new Object[0]).func_150254_d(), button -> {
            ++this.index;
            if (this.index >= Shaders.SHADER_LIST.size()) {
                this.index = 0;
            }
            this.sendShader();
        }));
        this.addButton((Widget)new Button(this.field_147003_i + this.field_146999_f / 2 - buttonWidth / 2, this.height / 2 + this.field_147000_g / 2 - buttonHeight - padding, buttonWidth, buttonHeight, new TranslationTextComponent("button.camera.upload", new Object[0]).func_150254_d(), button -> ImageTools.chooseImage(file -> {
            try {
                UUID uuid = UUID.randomUUID();
                BufferedImage image = ImageTools.loadImage(file);
                ClientImageUploadManager.addImage(uuid, image);
                Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageRequestUploadCustomImage(uuid));
            }
            catch (IOException e) {
                this.field_213127_e.field_70458_d.func_145747_a((ITextComponent)new TranslationTextComponent("message.upload_error", new Object[]{e.getMessage()}));
                e.printStackTrace();
            }
            this.minecraft.field_71462_r = null;
        })));
    }

    private void sendShader() {
        Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageSetShader(Shaders.SHADER_LIST.get(this.index)));
    }

    protected void func_146979_b(int x, int y) {
        super.func_146979_b(x, y);
        String title = new TranslationTextComponent("gui.camera.choosefilter", new Object[0]).func_150254_d();
        int titleWidth = this.font.func_78256_a(title);
        this.font.func_211126_b(title, (float)(this.field_146999_f / 2 - titleWidth / 2), 10.0f, 0x404040);
        String shaderName = new TranslationTextComponent("shader." + Shaders.SHADER_LIST.get(this.index), new Object[0]).func_150254_d();
        int shaderWidth = this.font.func_78256_a(shaderName);
        float f = this.field_146999_f / 2 - shaderWidth / 2;
        int n = this.field_147000_g / 2;
        this.font.getClass();
        this.font.func_175063_a(shaderName, f, (float)(n - 9 / 2), -1);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.renderBackground();
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.minecraft.func_110434_K().func_110577_a(CAMERA_TEXTURE);
        this.blit(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
    }
}

