/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.camera.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import de.maxhenkel.camera.Main;
import de.maxhenkel.camera.entities.ImageEntity;
import de.maxhenkel.camera.gui.DummyContainer;
import de.maxhenkel.camera.net.MessageResizeFrame;
import java.util.UUID;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class ResizeFrameScreen
extends ContainerScreen {
    private static final ResourceLocation CAMERA_TEXTURE = new ResourceLocation("camera", "textures/gui/camera.png");
    private static final int FONT_COLOR = 0x404040;
    private UUID uuid;
    private long lastCheck;

    public ResizeFrameScreen(UUID uuid) {
        super((Container)new DummyContainer(), null, (ITextComponent)new TranslationTextComponent("gui.frame.resize", new Object[0]));
        this.uuid = uuid;
        this.field_146999_f = 248;
        this.field_147000_g = 109;
    }

    protected void init() {
        super.init();
        this.buttons.clear();
        int left = (this.width - this.field_146999_f) / 2;
        int padding = 10;
        int buttonWidth = 50;
        int buttonHeight = 20;
        this.addButton((Widget)new Button(left + padding, this.height / 2 - buttonHeight / 2, buttonWidth, buttonHeight, new TranslationTextComponent("button.frame.left", new Object[0]).func_150254_d(), button -> this.sendMoveImage(MessageResizeFrame.Direction.LEFT)));
        this.addButton((Widget)new Button(left + this.field_146999_f - buttonWidth - padding, this.height / 2 - buttonHeight / 2, buttonWidth, buttonHeight, new TranslationTextComponent("button.frame.right", new Object[0]).func_150254_d(), button -> this.sendMoveImage(MessageResizeFrame.Direction.RIGHT)));
        this.addButton((Widget)new Button(this.width / 2 - buttonWidth / 2, this.field_147009_r + padding, buttonWidth, buttonHeight, new TranslationTextComponent("button.frame.up", new Object[0]).func_150254_d(), button -> this.sendMoveImage(MessageResizeFrame.Direction.UP)));
        this.addButton((Widget)new Button(this.width / 2 - buttonWidth / 2, this.field_147009_r + this.field_147000_g - padding - buttonHeight, buttonWidth, buttonHeight, new TranslationTextComponent("button.frame.down", new Object[0]).func_150254_d(), button -> this.sendMoveImage(MessageResizeFrame.Direction.DOWN)));
    }

    private void sendMoveImage(MessageResizeFrame.Direction direction) {
        Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageResizeFrame(this.uuid, direction, !Screen.hasShiftDown()));
    }

    protected void func_146979_b(int x, int y) {
        super.func_146979_b(x, y);
        String title = new TranslationTextComponent("gui.frame.resize", new Object[0]).func_150254_d();
        int titleWidth = this.font.func_78256_a(title);
        float f = this.field_146999_f / 2 - titleWidth / 2;
        int n = this.field_147000_g / 2;
        this.font.getClass();
        this.font.func_211126_b(title, f, (float)(n - 9 / 2), 0x404040);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.renderBackground();
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.minecraft.func_110434_K().func_110577_a(CAMERA_TEXTURE);
        this.blit(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    public void tick() {
        super.tick();
        if (System.currentTimeMillis() - this.lastCheck > 500L) {
            if (!this.isImagePresent()) {
                this.minecraft.field_71439_g.func_71053_j();
            }
            this.lastCheck = System.currentTimeMillis();
        }
    }

    public boolean isImagePresent() {
        AxisAlignedBB aabb = this.minecraft.field_71439_g.func_174813_aQ();
        if (aabb == null) {
            return false;
        }
        aabb = aabb.func_186662_g(32.0);
        return this.minecraft.field_71441_e.func_217357_a(ImageEntity.class, aabb).stream().anyMatch(image -> image.func_110124_au().equals(this.uuid) && image.func_70032_d((Entity)this.minecraft.field_71439_g) <= 32.0f);
    }
}

