/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.camera.integration.waila;

import de.maxhenkel.camera.Config;
import de.maxhenkel.camera.entities.ImageEntity;
import de.maxhenkel.camera.items.ItemImage;
import java.util.Date;
import java.util.List;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.api.IEntityAccessor;
import mcp.mobius.waila.api.IEntityComponentProvider;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.ITaggableList;
import mcp.mobius.waila.api.impl.config.WailaConfig;
import mcp.mobius.waila.utils.ModIdentification;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class HUDHandlerCars
implements IEntityComponentProvider {
    static final ResourceLocation OBJECT_NAME_TAG = new ResourceLocation("waila", "object_name");
    static final ResourceLocation CONFIG_SHOW_REGISTRY = new ResourceLocation("waila", "show_registry");
    static final ResourceLocation REGISTRY_NAME_TAG = new ResourceLocation("waila", "registry_name");
    static final HUDHandlerCars INSTANCE = new HUDHandlerCars();

    public void appendHead(List<ITextComponent> tooltip, IEntityAccessor accessor, IPluginConfig config) {
        ((ITaggableList)tooltip).setTag((Object)OBJECT_NAME_TAG, (Object)new StringTextComponent(String.format(((WailaConfig)Waila.CONFIG.get()).getFormatting().getEntityName(), accessor.getEntity().func_145748_c_().func_150254_d())));
        if (config.get(CONFIG_SHOW_REGISTRY)) {
            ((ITaggableList)tooltip).setTag((Object)REGISTRY_NAME_TAG, (Object)new StringTextComponent(accessor.getEntity().func_200600_R().getRegistryName().toString()).func_150255_a(new Style().func_150238_a(TextFormatting.GRAY)));
        }
    }

    public void appendBody(List<ITextComponent> tooltip, IEntityAccessor accessor, IPluginConfig config) {
        long time;
        if (!(accessor.getEntity() instanceof ImageEntity)) {
            return;
        }
        ImageEntity image = (ImageEntity)accessor.getEntity();
        ItemStack imageItem = image.getItem();
        if (!(imageItem.func_77973_b() instanceof ItemImage)) {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.image_frame_empty", new Object[0]));
            return;
        }
        String name = ItemImage.getOwner(imageItem);
        if (!name.isEmpty()) {
            tooltip.add(new TranslationTextComponent("tooltip.image_owner", new Object[]{TextFormatting.DARK_GRAY + name}).func_150255_a(new Style().func_150238_a(TextFormatting.GRAY)));
        }
        if ((time = ItemImage.getTime(imageItem)) > 0L) {
            tooltip.add(new TranslationTextComponent("tooltip.image_time", new Object[]{TextFormatting.DARK_GRAY + Config.getImageDateFormat().format(new Date(time))}).func_150255_a(new Style().func_150238_a(TextFormatting.GRAY)));
        }
    }

    public void appendTail(List<ITextComponent> tooltip, IEntityAccessor accessor, IPluginConfig config) {
        tooltip.add((ITextComponent)new StringTextComponent(String.format(((WailaConfig)Waila.CONFIG.get()).getFormatting().getModName(), ModIdentification.getModInfo((Entity)accessor.getEntity()).getName())));
    }
}

