/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.camera;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.ListNBT;

public class ItemTools {
    public static boolean isStackEmpty(ItemStack stack) {
        if (stack == null) {
            return true;
        }
        if (stack.equals(ItemStack.field_190927_a)) {
            return true;
        }
        if (stack.func_77973_b().equals(Items.field_190931_a)) {
            return true;
        }
        return stack.func_190916_E() <= 0;
    }

    public static boolean areItemsEqualWithEmpty(ItemStack stack1, ItemStack stack2) {
        if (ItemTools.isStackEmpty(stack1) && ItemTools.isStackEmpty(stack2)) {
            return true;
        }
        return ItemTools.areItemsEqual(stack1, stack2);
    }

    public static boolean areItemsEqual(ItemStack stack1, ItemStack stack2) {
        if (stack1 == null || stack2 == null) {
            return false;
        }
        if (stack1.func_77973_b() == null || stack2.func_77973_b() == null) {
            return false;
        }
        if (stack1.func_77973_b() == stack2.func_77973_b()) {
            return stack1.func_77952_i() == -1 || stack2.func_77952_i() == -1 || stack1.func_77952_i() == stack2.func_77952_i();
        }
        return false;
    }

    public static boolean contains(List<ItemStack> list, ItemStack item) {
        for (ItemStack i : list) {
            if (!ItemTools.areItemsEqual(item, i)) continue;
            return true;
        }
        return false;
    }

    public static int itemStackAmount(int amount, ItemStack stack, PlayerEntity player) {
        if (stack == null) {
            return 0;
        }
        if (player == null || !player.field_71075_bZ.field_75098_d) {
            stack.func_190920_e(stack.func_190916_E() + amount);
            if (stack.func_190916_E() <= 0) {
                stack.func_190920_e(0);
            }
        }
        if (stack.func_190916_E() > stack.func_77976_d()) {
            stack.func_190920_e(stack.func_77976_d());
        }
        return stack.func_190916_E();
    }

    public static int decrItemStack(ItemStack stack, PlayerEntity player) {
        return ItemTools.itemStackAmount(-1, stack, player);
    }

    public static int incrItemStack(ItemStack stack, PlayerEntity player) {
        return ItemTools.itemStackAmount(1, stack, player);
    }

    public static void removeStackFromSlot(IInventory inventory, int index) {
        inventory.func_70299_a(index, ItemStack.field_190927_a);
    }

    public static void saveInventory(CompoundNBT compound, String name, IInventory inv) {
        ListNBT nbttaglist = new ListNBT();
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            if (ItemTools.isStackEmpty(inv.func_70301_a(i))) continue;
            CompoundNBT nbttagcompound = new CompoundNBT();
            nbttagcompound.func_74768_a("Slot", i);
            inv.func_70301_a(i).func_77955_b(nbttagcompound);
            nbttaglist.add((Object)nbttagcompound);
        }
        compound.func_218657_a(name, (INBT)nbttaglist);
    }

    public static void readInventory(CompoundNBT compound, String name, IInventory inv) {
        if (!compound.func_74764_b(name)) {
            return;
        }
        ListNBT nbttaglist = compound.func_150295_c(name, 10);
        if (nbttaglist == null) {
            return;
        }
        for (int i = 0; i < nbttaglist.size(); ++i) {
            CompoundNBT nbttagcompound = nbttaglist.func_150305_b(i);
            int j = nbttagcompound.func_74762_e("Slot");
            if (j < 0 || j >= inv.func_70302_i_()) continue;
            inv.func_70299_a(j, ItemStack.func_199557_a((CompoundNBT)nbttagcompound));
        }
    }

    public static String serializeItemStack(ItemStack stack) {
        return stack.serializeNBT().toString();
    }

    public static ItemStack deserializeItemStack(String json) {
        try {
            return ItemStack.func_199557_a((CompoundNBT)JsonToNBT.func_180713_a((String)json));
        }
        catch (CommandSyntaxException e) {
            e.printStackTrace();
            return ItemStack.field_190927_a;
        }
    }
}

