/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.camera.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import de.maxhenkel.camera.Config;
import de.maxhenkel.camera.Main;
import de.maxhenkel.camera.entities.ImageEntity;
import de.maxhenkel.camera.gui.DummyContainer;
import de.maxhenkel.camera.net.MessageResizeFrame;
import java.util.UUID;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class ResizeFrameScreen
extends ContainerScreen {
    private static final ResourceLocation CAMERA_TEXTURE = new ResourceLocation("camera", "textures/gui/resize_frame.png");
    private static final int PADDING = 10;
    private static final int BUTTON_HEIGHT = 20;
    private static final int BUTTON_WIDTH = 50;
    private UUID uuid;
    private float visibility;
    private Button visibilityButton;
    private long lastCheck;

    public ResizeFrameScreen(UUID uuid) {
        super((Container)new DummyContainer(), null, (ITextComponent)new TranslationTextComponent("gui.frame.resize", new Object[0]));
        this.uuid = uuid;
        this.visibility = ((Double)Config.CLIENT.RESIZE_GUI_OPACITY.get()).floatValue();
        this.field_146999_f = 248;
        this.field_147000_g = 109;
    }

    protected void init() {
        super.init();
        this.buttons.clear();
        int left = (this.width - this.field_146999_f) / 2;
        this.addButton((Widget)new Button(left + 10, this.height / 2 - 10, 50, 20, "", button -> this.sendMoveImage(MessageResizeFrame.Direction.LEFT)));
        this.addButton((Widget)new Button(left + this.field_146999_f - 50 - 10, this.height / 2 - 10, 50, 20, "", button -> this.sendMoveImage(MessageResizeFrame.Direction.RIGHT)));
        this.addButton((Widget)new Button(this.width / 2 - 25, this.field_147009_r + 10, 50, 20, "", button -> this.sendMoveImage(MessageResizeFrame.Direction.UP)));
        this.addButton((Widget)new Button(this.width / 2 - 25, this.field_147009_r + this.field_147000_g - 10 - 20, 50, 20, "", button -> this.sendMoveImage(MessageResizeFrame.Direction.DOWN)));
        this.visibilityButton = new Button(left + this.field_146999_f - 20 - 10, this.field_147009_r + 10, 20, 20, new TranslationTextComponent("tooltip.visibility_short", new Object[0]).func_150254_d(), button -> {
            this.visibility = (float)((double)this.visibility - 0.25);
            if (this.visibility < 0.0f) {
                this.visibility = 1.0f;
            }
            Config.CLIENT.RESIZE_GUI_OPACITY.set((Object)this.visibility);
            Config.CLIENT.RESIZE_GUI_OPACITY.save();
        });
        this.addButton((Widget)this.visibilityButton);
    }

    private void sendMoveImage(MessageResizeFrame.Direction direction) {
        Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageResizeFrame(this.uuid, direction, !Screen.hasShiftDown()));
    }

    protected void func_146979_b(int x, int y) {
        super.func_146979_b(x, y);
        String title = new TranslationTextComponent("gui.frame.resize", new Object[0]).func_150254_d();
        int titleWidth = this.font.func_78256_a(title);
        float f = this.field_146999_f / 2 - titleWidth / 2;
        int n = this.field_147000_g / 2;
        this.font.getClass();
        this.font.func_211126_b(title, f, (float)(n - 9 - 1), TextFormatting.DARK_GRAY.func_211163_e().intValue());
        String description = new TranslationTextComponent("gui.frame.resize_description", new Object[0]).func_150254_d();
        int descriptionWidth = this.font.func_78256_a(description);
        this.font.func_211126_b(description, (float)(this.field_146999_f / 2 - descriptionWidth / 2), (float)(this.field_147000_g / 2 + 1), TextFormatting.GRAY.func_211163_e().intValue());
        this.minecraft.func_110434_K().func_110577_a(CAMERA_TEXTURE);
        if (Screen.hasShiftDown()) {
            this.blit(this.field_146999_f / 2 - 8, 12, 16, 109, 16, 16);
            this.blit(this.field_146999_f / 2 - 8, this.field_147000_g - 10 - 20 + 2, 0, 109, 16, 16);
            this.blit(27, this.field_147000_g / 2 - 10 + 3, 0, 125, 16, 16);
            this.blit(this.field_146999_f - 10 - 25 - 8, this.field_147000_g / 2 - 10 + 3, 16, 125, 16, 16);
        } else {
            this.blit(this.field_146999_f / 2 - 8, 12, 0, 109, 16, 16);
            this.blit(this.field_146999_f / 2 - 8, this.field_147000_g - 10 - 20 + 2, 16, 109, 16, 16);
            this.blit(27, this.field_147000_g / 2 - 10 + 3, 16, 125, 16, 16);
            this.blit(this.field_146999_f - 10 - 25 - 8, this.field_147000_g / 2 - 10 + 3, 0, 125, 16, 16);
        }
        if (this.visibilityButton.isHovered()) {
            this.renderTooltip(new TranslationTextComponent("tooltip.visibility", new Object[0]).func_150254_d(), x - this.field_147003_i, y - this.field_147009_r);
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        if (this.visibility >= 1.0f) {
            this.renderBackground();
        }
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)this.visibility);
        this.minecraft.func_110434_K().func_110577_a(CAMERA_TEXTURE);
        this.blit(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    public void tick() {
        super.tick();
        if (System.currentTimeMillis() - this.lastCheck > 500L) {
            if (!this.isImagePresent()) {
                this.minecraft.field_71439_g.func_71053_j();
            }
            this.lastCheck = System.currentTimeMillis();
        }
    }

    public boolean isImagePresent() {
        AxisAlignedBB aabb = this.minecraft.field_71439_g.func_174813_aQ();
        if (aabb == null) {
            return false;
        }
        aabb = aabb.func_186662_g(32.0);
        return this.minecraft.field_71441_e.func_217357_a(ImageEntity.class, aabb).stream().anyMatch(image -> image.func_110124_au().equals(this.uuid) && image.func_70032_d((Entity)this.minecraft.field_71439_g) <= 32.0f);
    }
}

