/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.camera;

import java.text.SimpleDateFormat;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;

public class Config {
    public static final ServerConfig SERVER;
    public static final ForgeConfigSpec SERVER_SPEC;
    public static final ClientConfig CLIENT;
    public static final ForgeConfigSpec CLIENT_SPEC;
    private static SimpleDateFormat cachedDateFormat;

    private static SimpleDateFormat getDateFormat(String format) {
        return new SimpleDateFormat(format);
    }

    public static Item getConsumingItem() {
        return (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation((String)Config.SERVER.CAMERA_CONSUME_ITEM.get()));
    }

    public static SimpleDateFormat getImageDateFormat() {
        if (cachedDateFormat == null) {
            cachedDateFormat = Config.getDateFormat((String)Config.CLIENT.IMAGE_DATE_FORMAT.get());
        }
        return cachedDateFormat;
    }

    public static void onServerConfigUpdate() {
    }

    public static void onClientConfigUpdate() {
        cachedDateFormat = null;
    }

    static {
        Pair specPairServer = new ForgeConfigSpec.Builder().configure(ServerConfig::new);
        SERVER_SPEC = (ForgeConfigSpec)specPairServer.getRight();
        SERVER = (ServerConfig)specPairServer.getLeft();
        Pair specPairClient = new ForgeConfigSpec.Builder().configure(ClientConfig::new);
        CLIENT_SPEC = (ForgeConfigSpec)specPairClient.getRight();
        CLIENT = (ClientConfig)specPairClient.getLeft();
    }

    public static class ClientConfig {
        public ForgeConfigSpec.ConfigValue<String> IMAGE_DATE_FORMAT;
        public ForgeConfigSpec.ConfigValue<String> LAST_IMAGE_PATH;
        public ForgeConfigSpec.BooleanValue RENDER_IMAGE_ITEM;
        public ForgeConfigSpec.DoubleValue RESIZE_GUI_OPACITY;

        public ClientConfig(ForgeConfigSpec.Builder builder) {
            this.IMAGE_DATE_FORMAT = builder.comment("The format the date will be displayed on the image").define("image_date_format", (Object)"MM/dd/yyyy HH:mm");
            this.LAST_IMAGE_PATH = builder.define("last_image_path", (Object)"");
            this.RENDER_IMAGE_ITEM = builder.comment("If the image item should render the actual image (This may cause poor performance)").define("render_image_item", true);
            this.RESIZE_GUI_OPACITY = builder.comment("The opacity of the resize image frame GUI").defineInRange("resize_gui_opacity", 1.0, 0.0, 1.0);
        }
    }

    public static class ServerConfig {
        public ForgeConfigSpec.IntValue IMAGE_COOLDOWN;
        public ForgeConfigSpec.ConfigValue<String> CAMERA_CONSUME_ITEM;
        public ForgeConfigSpec.IntValue CAMERA_CONSUME_ITEM_AMOUNT;
        public ForgeConfigSpec.IntValue MAX_IMAGE_SIZE;
        public ForgeConfigSpec.DoubleValue IMAGE_COMPRESSION;
        public ForgeConfigSpec.BooleanValue ALLOW_IMAGE_UPLOAD;

        public ServerConfig(ForgeConfigSpec.Builder builder) {
            this.IMAGE_COOLDOWN = builder.comment("The time in milliseconds the camera will be on cooldown after taking an image").defineInRange("camera.cooldown", 5000, 100, Integer.MAX_VALUE);
            this.CAMERA_CONSUME_ITEM = builder.comment("The item that is consumed when taking an image").define("camera.consumed_item.item", (Object)"minecraft:paper");
            this.CAMERA_CONSUME_ITEM_AMOUNT = builder.comment("The amount of the item that is consumed when taking an image").defineInRange("camera.consumed_item.amount", 1, 1, Short.MAX_VALUE);
            this.MAX_IMAGE_SIZE = builder.comment(new String[]{"The maximum size of an image in bytes when transferred to the server", "Higher values mean more delay/lag between taking an image and getting it into your inventory"}).defineInRange("image.max_size", 200000, 50000, 1000000);
            this.IMAGE_COMPRESSION = builder.comment(new String[]{"The amount of jpeg compression applied to the image", "If the image exceeds the 'max_image_size', it will get compressed anyways"}).defineInRange("image.compression", 0.5, 0.1, 1.0);
            this.ALLOW_IMAGE_UPLOAD = builder.comment("If it is allowed to upload custom images").define("image.allow_upload", true);
        }
    }
}

