/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.camera;

import de.maxhenkel.camera.ImageTools;
import de.maxhenkel.camera.Main;
import de.maxhenkel.camera.net.MessageRequestImage;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.texture.Texture;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TextureCache {
    private Map<UUID, CameraTextureObject> clientImageCache = new HashMap<UUID, CameraTextureObject>();
    private Map<UUID, ResourceLocation> clientResourceCache = new HashMap<UUID, ResourceLocation>();
    private Map<UUID, Long> awaitingImages = new HashMap<UUID, Long>();
    public static TextureCache instance;

    public void addImage(UUID uuid, BufferedImage image) {
        if (this.awaitingImages.containsKey(uuid)) {
            this.awaitingImages.remove(uuid);
        }
        ResourceLocation resourceLocation = new ResourceLocation("camera", "texures/camera/" + uuid.toString());
        CameraTextureObject cameraTextureObject = new CameraTextureObject(ImageTools.toNativeImage(image));
        this.clientImageCache.put(uuid, cameraTextureObject);
        this.clientResourceCache.put(uuid, resourceLocation);
        Minecraft.func_71410_x().func_175598_ae().field_78724_e.func_229263_a_(resourceLocation, (Texture)cameraTextureObject);
    }

    public ResourceLocation getImage(UUID uuid) {
        CameraTextureObject cameraTextureObject = this.clientImageCache.get(uuid);
        if (this.checkImage(uuid, cameraTextureObject)) {
            return null;
        }
        return this.clientResourceCache.get(uuid);
    }

    private boolean checkImage(UUID uuid, CameraTextureObject cameraTextureObject) {
        if (cameraTextureObject == null) {
            if (this.awaitingImages.containsKey(uuid) && this.awaitingImages.get(uuid) + 10000L > System.currentTimeMillis()) {
                return true;
            }
            this.awaitingImages.put(uuid, System.currentTimeMillis());
            Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageRequestImage(uuid));
            return true;
        }
        return false;
    }

    public NativeImage getNativeImage(UUID uuid) {
        CameraTextureObject cameraTextureObject = this.clientImageCache.get(uuid);
        if (this.checkImage(uuid, cameraTextureObject)) {
            return null;
        }
        return cameraTextureObject.func_195414_e();
    }

    public static TextureCache instance() {
        if (instance == null) {
            instance = new TextureCache();
        }
        return instance;
    }

    public class CameraTextureObject
    extends DynamicTexture {
        public CameraTextureObject(NativeImage image) {
            super(image);
        }
    }
}

