/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.camera.items;

import de.maxhenkel.camera.Config;
import de.maxhenkel.camera.ItemTools;
import de.maxhenkel.camera.Main;
import de.maxhenkel.camera.ModSounds;
import de.maxhenkel.camera.gui.CameraScreen;
import de.maxhenkel.camera.net.MessageTakeImage;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkDirection;

public class CameraItem
extends Item {
    public CameraItem() {
        super(new Item.Properties().func_200917_a(1).func_200916_a(ItemGroup.field_78031_c));
        this.setRegistryName(new ResourceLocation("camera", "camera"));
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (playerIn.func_225608_bj_() && !this.isActive(stack)) {
            if (worldIn.field_72995_K) {
                this.openClientGui(this.getShader(stack));
            }
            return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
        }
        if (!(playerIn instanceof ServerPlayerEntity)) {
            return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
        }
        if (!this.isActive(stack)) {
            Main.CAMERA.setActive(stack, true);
        } else if (Main.PACKET_MANAGER.canTakeImage(playerIn.func_110124_au())) {
            if (CameraItem.consumePaper(playerIn)) {
                worldIn.func_184133_a(null, playerIn.func_233580_cy_(), ModSounds.TAKE_IMAGE, SoundCategory.AMBIENT, 1.0f, 1.0f);
                UUID uuid = UUID.randomUUID();
                Main.SIMPLE_CHANNEL.sendTo((Object)new MessageTakeImage(uuid), ((ServerPlayerEntity)playerIn).field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
                Main.CAMERA.setActive(stack, false);
            } else {
                playerIn.func_146105_b((ITextComponent)new TranslationTextComponent("message.no_consumable", new Object[]{new TranslationTextComponent(Config.getConsumingItem().func_77658_a()), Config.SERVER.CAMERA_CONSUME_ITEM_AMOUNT.get()}), true);
            }
        } else {
            playerIn.func_146105_b((ITextComponent)new TranslationTextComponent("message.image_cooldown"), true);
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void openClientGui(String currentShader) {
        Minecraft.func_71410_x().func_147108_a((Screen)new CameraScreen(currentShader));
    }

    public int func_77626_a(ItemStack stack) {
        return 50000;
    }

    public UseAction func_77661_b(ItemStack stack) {
        if (this.isActive(stack)) {
            return UseAction.BOW;
        }
        return UseAction.NONE;
    }

    public static boolean consumePaper(PlayerEntity player) {
        if (player.field_71075_bZ.field_75098_d) {
            return true;
        }
        int amountNeeded = (Integer)Config.SERVER.CAMERA_CONSUME_ITEM_AMOUNT.get();
        List<ItemStack> consumeStacks = CameraItem.findPaper(player);
        int count = 0;
        for (ItemStack stack : consumeStacks) {
            count += stack.func_190916_E();
        }
        if (count >= amountNeeded) {
            for (ItemStack stack : consumeStacks) {
                amountNeeded -= stack.func_190916_E() - ItemTools.itemStackAmount(-amountNeeded, stack, null);
            }
            return true;
        }
        return false;
    }

    private static List<ItemStack> findPaper(PlayerEntity player) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        if (CameraItem.isPaper(player.func_184586_b(Hand.MAIN_HAND))) {
            items.add(player.func_184586_b(Hand.MAIN_HAND));
        }
        if (CameraItem.isPaper(player.func_184586_b(Hand.OFF_HAND))) {
            items.add(player.func_184586_b(Hand.OFF_HAND));
        }
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack itemstack = player.field_71071_by.func_70301_a(i);
            if (!CameraItem.isPaper(itemstack)) continue;
            items.add(itemstack);
        }
        return items;
    }

    protected static boolean isPaper(ItemStack stack) {
        return stack.func_77973_b().equals(Config.getConsumingItem());
    }

    public boolean isActive(ItemStack stack) {
        CompoundNBT compound = stack.func_196082_o();
        if (!compound.func_74764_b("active")) {
            compound.func_74757_a("active", false);
        }
        return compound.func_74767_n("active");
    }

    public void setActive(ItemStack stack, boolean active) {
        stack.func_196082_o().func_74757_a("active", active);
    }

    public String getShader(ItemStack stack) {
        CompoundNBT compound = stack.func_196082_o();
        if (!compound.func_74764_b("shader")) {
            return null;
        }
        return compound.func_74779_i("shader");
    }

    public void setShader(ItemStack stack, String shader) {
        if (shader != null) {
            stack.func_196082_o().func_74778_a("shader", shader);
        }
    }
}

