/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.blocks;

import com.mrcrayfish.furniture.blocks.BlockFurnitureTile;
import com.mrcrayfish.furniture.entity.EntitySittableBlock;
import com.mrcrayfish.furniture.init.FurnitureAchievements;
import com.mrcrayfish.furniture.init.FurnitureBlocks;
import com.mrcrayfish.furniture.tileentity.TileEntityCouch;
import com.mrcrayfish.furniture.util.CollisionHelper;
import com.mrcrayfish.furniture.util.SittableUtil;
import com.mrcrayfish.furniture.util.StateHelper;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class BlockCouch
extends BlockFurnitureTile {
    public static final PropertyInteger COLOUR = PropertyInteger.func_177719_a((String)"colour", (int)0, (int)15);
    public static final PropertyEnum TYPE = PropertyEnum.func_177709_a((String)"type", CouchType.class);

    public BlockCouch() {
        super(Material.field_151580_n);
        this.func_149711_c(0.5f);
        this.func_149672_a(Block.field_149775_l);
        IBlockState baseState = this.field_176227_L.func_177621_b();
        if (this.isSpecial()) {
            this.func_180632_j(baseState.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)TYPE, (Comparable)((Object)CouchType.BOTH)));
        } else {
            this.func_180632_j(baseState.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)TYPE, (Comparable)((Object)CouchType.BOTH)).func_177226_a((IProperty)COLOUR, (Comparable)Integer.valueOf(0)));
        }
    }

    public void func_180654_a(IBlockAccess blockAccess, BlockPos pos) {
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    public void func_180638_a(World world, BlockPos pos, IBlockState state, AxisAlignedBB mask, List list, Entity collidingEntity) {
        if (!(collidingEntity instanceof EntitySittableBlock)) {
            int facing = this.func_176201_c(state);
            float[] data = CollisionHelper.fixRotation(facing, 0.8f, 0.0f, 1.0f, 1.0f);
            this.func_149676_a(data[0], 0.6f, data[1], data[2], 1.21f, data[3]);
            super.func_180638_a(world, pos, state, mask, list, collidingEntity);
            this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.6f, 1.0f);
            super.func_180638_a(world, pos, state, mask, list, collidingEntity);
            if (StateHelper.getBlock((IBlockAccess)world, pos, (EnumFacing)state.func_177229_b((IProperty)FACING), StateHelper.Direction.DOWN) instanceof BlockCouch) {
                if (StateHelper.getRotation((IBlockAccess)world, pos, (EnumFacing)state.func_177229_b((IProperty)FACING), StateHelper.Direction.DOWN) == StateHelper.Direction.RIGHT) {
                    data = CollisionHelper.fixRotation(facing, 0.0f, 0.75f, 0.75f, 1.0f);
                    this.func_149676_a(data[0], 0.6f, data[1], data[2], 1.21f, data[3]);
                    super.func_180638_a(world, pos, state, mask, list, collidingEntity);
                } else if (StateHelper.getRotation((IBlockAccess)world, pos, (EnumFacing)state.func_177229_b((IProperty)FACING), StateHelper.Direction.DOWN) == StateHelper.Direction.LEFT) {
                    data = CollisionHelper.fixRotation(facing, 0.0f, 0.0f, 0.75f, 0.25f);
                    this.func_149676_a(data[0], 0.6f, data[1], data[2], 1.21f, data[3]);
                    super.func_180638_a(world, pos, state, mask, list, collidingEntity);
                }
                return;
            }
            if (StateHelper.isAirBlock((IBlockAccess)world, pos, (EnumFacing)state.func_177229_b((IProperty)FACING), StateHelper.Direction.LEFT)) {
                data = CollisionHelper.fixRotation(facing, 0.0f, 9.9f, 1.0f, 1.0f);
                this.func_149676_a(data[0], 0.5f, data[1], data[2], 0.9f, data[3]);
                super.func_180638_a(world, pos, state, mask, list, collidingEntity);
            }
            if (StateHelper.isAirBlock((IBlockAccess)world, pos, (EnumFacing)state.func_177229_b((IProperty)FACING), StateHelper.Direction.RIGHT)) {
                data = CollisionHelper.fixRotation(facing, 0.0f, 0.0f, 1.0f, 0.1f);
                this.func_149676_a(data[0], 0.5f, data[1], data[2], 0.9f, data[3]);
                super.func_180638_a(world, pos, state, mask, list, collidingEntity);
            }
        }
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (!this.isSpecial()) {
            int colour = ((TileEntityCouch)world.func_175625_s(pos)).getColour();
            state = state.func_177226_a((IProperty)COLOUR, (Comparable)Integer.valueOf(colour));
        }
        if (StateHelper.getBlock(world, pos, (EnumFacing)state.func_177229_b((IProperty)FACING), StateHelper.Direction.DOWN) instanceof BlockCouch) {
            if (StateHelper.getRotation(world, pos, (EnumFacing)state.func_177229_b((IProperty)FACING), StateHelper.Direction.DOWN) == StateHelper.Direction.RIGHT) {
                return state.func_177226_a((IProperty)TYPE, (Comparable)((Object)CouchType.CORNER_RIGHT));
            }
            if (StateHelper.getRotation(world, pos, (EnumFacing)state.func_177229_b((IProperty)FACING), StateHelper.Direction.DOWN) == StateHelper.Direction.LEFT) {
                return state.func_177226_a((IProperty)TYPE, (Comparable)((Object)CouchType.CORNER_LEFT));
            }
        }
        boolean left = false;
        boolean right = false;
        if (!StateHelper.isAirBlock(world, pos, (EnumFacing)state.func_177229_b((IProperty)FACING), StateHelper.Direction.LEFT)) {
            left = true;
        }
        if (!StateHelper.isAirBlock(world, pos, (EnumFacing)state.func_177229_b((IProperty)FACING), StateHelper.Direction.RIGHT)) {
            right = true;
        }
        if (left && !right) {
            return state.func_177226_a((IProperty)TYPE, (Comparable)((Object)CouchType.LEFT));
        }
        if (!left && right) {
            return state.func_177226_a((IProperty)TYPE, (Comparable)((Object)CouchType.RIGHT));
        }
        if (!left && !right) {
            return state.func_177226_a((IProperty)TYPE, (Comparable)((Object)CouchType.BOTH));
        }
        return state.func_177226_a((IProperty)TYPE, (Comparable)((Object)CouchType.NONE));
    }

    @Override
    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        IBlockState state = super.func_180642_a(world, pos, facing, hitX, hitY, hitZ, meta, placer);
        if (!this.isSpecial()) {
            state = state.func_177226_a((IProperty)COLOUR, (Comparable)Integer.valueOf(0));
        }
        return state;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!this.isSpecial()) {
            ItemStack currentItem = playerIn.func_71045_bC();
            if (currentItem != null && currentItem.func_77973_b() == Items.field_151057_cb && currentItem.func_82837_s() && currentItem.func_82833_r().equals("jeb_")) {
                playerIn.func_71029_a((StatBase)FurnitureAchievements.jebCouch);
                worldIn.func_175656_a(pos, FurnitureBlocks.couch_jeb.func_176223_P().func_177226_a((IProperty)FACING, state.func_177229_b((IProperty)FACING)));
                --currentItem.field_77994_a;
                return true;
            }
            TileEntity tileEntity = worldIn.func_175625_s(pos);
            if (tileEntity instanceof TileEntityCouch) {
                TileEntityCouch tileEntityCouch = (TileEntityCouch)tileEntity;
                if (currentItem != null && currentItem.func_77973_b() instanceof ItemDye) {
                    tileEntityCouch.setColour(currentItem.func_77952_i());
                    --currentItem.field_77994_a;
                    worldIn.func_175689_h(pos);
                    return true;
                }
            }
        }
        return SittableUtil.sitOnBlock(worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), playerIn, 0.45);
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityCouch();
    }

    @Override
    protected BlockState func_180661_e() {
        return this.isSpecial() ? new BlockState((Block)this, new IProperty[]{FACING, TYPE}) : new BlockState((Block)this, new IProperty[]{FACING, COLOUR, TYPE});
    }

    public abstract boolean isSpecial();

    public static enum CouchType implements IStringSerializable
    {
        NONE,
        LEFT,
        RIGHT,
        BOTH,
        CORNER_LEFT,
        CORNER_RIGHT;


        public String func_176610_l() {
            return this.toString().toLowerCase();
        }
    }
}

