/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.network.message;

import com.mrcrayfish.furniture.api.RecipeData;
import com.mrcrayfish.furniture.api.Recipes;
import com.mrcrayfish.furniture.init.FurnitureAchievements;
import com.mrcrayfish.furniture.tileentity.TileEntityComputer;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageMineBayBuy
implements IMessage,
IMessageHandler<MessageMineBayBuy, IMessage> {
    private int itemNum;
    private int x;
    private int y;
    private int z;
    private boolean shouldClear;

    public MessageMineBayBuy() {
    }

    public MessageMineBayBuy(int itemNum, int x, int y, int z, boolean shouldClear) {
        this.itemNum = itemNum;
        this.x = x;
        this.y = y;
        this.z = z;
        this.shouldClear = shouldClear;
    }

    public void fromBytes(ByteBuf buf) {
        this.itemNum = buf.readInt();
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.shouldClear = buf.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.itemNum);
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        buf.writeBoolean(this.shouldClear);
    }

    public IMessage onMessage(MessageMineBayBuy message, MessageContext ctx) {
        EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
        TileEntity tile_entity = player.field_70170_p.func_175625_s(new BlockPos(message.x, message.y, message.z));
        if (tile_entity instanceof TileEntityComputer) {
            TileEntityComputer tileEntityComputer = (TileEntityComputer)tile_entity;
            ItemStack buySlot = tileEntityComputer.func_70301_a(0);
            RecipeData[] data = Recipes.getMineBayItems();
            int price = data[message.itemNum].getPrice();
            if (buySlot == null) {
                return null;
            }
            if (message.shouldClear) {
                tileEntityComputer.clearInventory();
            } else {
                tileEntityComputer.takeEmeraldFromSlot(price);
            }
            EntityItem var14 = new EntityItem(player.field_70170_p, player.field_70165_t, player.field_70163_u + 1.0, player.field_70161_v, data[message.itemNum].getInput().func_77946_l());
            player.field_70170_p.func_72838_d((Entity)var14);
            player.func_71029_a((StatBase)FurnitureAchievements.buyItem);
        }
        return null;
    }
}

