/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.tileentity;

import com.mrcrayfish.furniture.api.RecipeAPI;
import com.mrcrayfish.furniture.api.RecipeData;
import com.mrcrayfish.furniture.gui.inventory.ISimpleInventory;
import com.mrcrayfish.furniture.init.FurnitureItems;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.server.gui.IUpdatePlayerListBox;
import net.minecraft.tileentity.TileEntity;

public class TileEntityBlender
extends TileEntity
implements IUpdatePlayerListBox,
ISimpleInventory {
    public ItemStack[] ingredients = new ItemStack[4];
    private boolean blending = false;
    public int progress = 0;
    public int drinkCount = 0;
    public String drinkName = "";
    public int healAmount;
    public int currentRed;
    public int currentGreen;
    public int currentBlue;
    int timer = 0;

    public void addIngredient(ItemStack ingredient) {
        for (int i = 0; i < this.ingredients.length; ++i) {
            if (this.ingredients[i] != null) continue;
            this.ingredients[i] = ingredient.func_77946_l();
            break;
        }
    }

    public void removeIngredient() {
        for (int i = this.ingredients.length - 1; i >= 0; --i) {
            if (this.ingredients[i] == null) continue;
            if (!this.field_145850_b.field_72995_K) {
                EntityItem entityItem = new EntityItem(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 1.0, (double)this.field_174879_c.func_177952_p() + 0.5, this.ingredients[i]);
                this.field_145850_b.func_72838_d((Entity)entityItem);
            }
            this.ingredients[i] = null;
            break;
        }
        this.field_145850_b.func_175689_h(this.field_174879_c);
    }

    public boolean isFull() {
        for (int i = 0; i < this.ingredients.length; ++i) {
            if (this.ingredients[i] != null) continue;
            return false;
        }
        return true;
    }

    public ItemStack[] getIngredients() {
        return this.ingredients;
    }

    public boolean hasValidIngredients() {
        RecipeData data = RecipeAPI.getBlenderRecipeDataFromIngredients(this.ingredients);
        if (data == null) {
            return false;
        }
        this.drinkName = data.getDrinkName();
        this.healAmount = data.getHealAmount();
        this.currentRed = data.getRed();
        this.currentGreen = data.getGreen();
        this.currentBlue = data.getBlue();
        return true;
    }

    public void startBlending() {
        this.blending = true;
    }

    public boolean isBlending() {
        return this.blending;
    }

    public boolean hasDrink() {
        return this.drinkCount > 0;
    }

    public ItemStack getDrink() {
        ItemStack cup = new ItemStack(FurnitureItems.itemDrink);
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74783_a("Colour", new int[]{this.currentRed, this.currentGreen, this.currentBlue});
        nbt.func_74768_a("HealAmount", this.healAmount);
        cup.func_77982_d(nbt);
        cup.func_151001_c(new String(this.drinkName));
        return cup;
    }

    public void func_73660_a() {
        if (this.blending) {
            ++this.progress;
            if (this.progress == 200) {
                this.clearIngredients();
                this.drinkCount = 6;
                this.progress = 0;
                this.blending = false;
                this.field_145850_b.func_175666_e(this.field_174879_c, this.field_145854_h);
            }
            if (this.timer == 20) {
                this.timer = 0;
            }
            if (this.timer == 0) {
                this.field_145850_b.func_72908_a((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), "cfm:blender", 0.75f, 1.0f);
            }
            ++this.timer;
        }
    }

    public void clearIngredients() {
        for (int i = 0; i < this.ingredients.length; ++i) {
            if (this.ingredients[i] == null) continue;
            if (this.ingredients[i].func_77973_b().func_77634_r() && !this.field_145850_b.field_72995_K) {
                EntityItem entityItem = new EntityItem(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.6, (double)this.field_174879_c.func_177952_p() + 0.5, new ItemStack(this.ingredients[i].func_77973_b().func_77668_q()));
                this.field_145850_b.func_72838_d((Entity)entityItem);
            }
            this.ingredients[i] = null;
        }
    }

    public void func_145839_a(NBTTagCompound par1NBTTagCompound) {
        super.func_145839_a(par1NBTTagCompound);
        if (par1NBTTagCompound.func_74764_b("Items")) {
            NBTTagList tagList = (NBTTagList)par1NBTTagCompound.func_74781_a("Items");
            this.ingredients = new ItemStack[4];
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                NBTTagCompound nbt = tagList.func_150305_b(i);
                byte s = nbt.func_74771_c("Slot");
                if (s < 0 || s >= this.ingredients.length) continue;
                this.ingredients[s] = ItemStack.func_77949_a((NBTTagCompound)nbt);
            }
        }
        this.blending = par1NBTTagCompound.func_74767_n("Blending");
        this.progress = par1NBTTagCompound.func_74762_e("Progress");
        this.drinkCount = par1NBTTagCompound.func_74762_e("DrinkCount");
        this.drinkName = par1NBTTagCompound.func_74779_i("DrinkName");
        this.healAmount = par1NBTTagCompound.func_74762_e("HealAmount");
        this.currentRed = par1NBTTagCompound.func_74762_e("CurrentRed");
        this.currentGreen = par1NBTTagCompound.func_74762_e("CurrentGreen");
        this.currentBlue = par1NBTTagCompound.func_74762_e("CurrentBlue");
    }

    public void func_145841_b(NBTTagCompound par1NBTTagCompound) {
        super.func_145841_b(par1NBTTagCompound);
        NBTTagList tagList = new NBTTagList();
        for (int i = 0; i < this.ingredients.length; ++i) {
            if (this.ingredients[i] == null) continue;
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74774_a("Slot", (byte)i);
            this.ingredients[i].func_77955_b(nbt);
            tagList.func_74742_a((NBTBase)nbt);
        }
        par1NBTTagCompound.func_74782_a("Items", (NBTBase)tagList);
        par1NBTTagCompound.func_74757_a("Blending", this.blending);
        par1NBTTagCompound.func_74768_a("Progress", this.progress);
        par1NBTTagCompound.func_74778_a("DrinkName", this.drinkName);
        par1NBTTagCompound.func_74768_a("DrinkCount", this.drinkCount);
        par1NBTTagCompound.func_74768_a("HealAmount", this.healAmount);
        par1NBTTagCompound.func_74768_a("CurrentRed", this.currentRed);
        par1NBTTagCompound.func_74768_a("CurrentGreen", this.currentGreen);
        par1NBTTagCompound.func_74768_a("CurrentBlue", this.currentBlue);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        NBTTagCompound tagCom = pkt.func_148857_g();
        this.func_145839_a(tagCom);
    }

    public Packet func_145844_m() {
        NBTTagCompound tagCom = new NBTTagCompound();
        this.func_145841_b(tagCom);
        return new S35PacketUpdateTileEntity(this.field_174879_c, this.func_145832_p(), tagCom);
    }

    @Override
    public int getSize() {
        return this.ingredients.length;
    }

    @Override
    public ItemStack getItem(int i) {
        return this.ingredients[i];
    }

    @Override
    public void clear() {
        for (int i = 0; i < this.ingredients.length; ++i) {
            this.ingredients[i] = null;
        }
    }
}

