/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.tileentity;

import com.mrcrayfish.furniture.api.RecipeAPI;
import com.mrcrayfish.furniture.api.RecipeData;
import com.mrcrayfish.furniture.api.Recipes;
import com.mrcrayfish.furniture.gui.containers.ContainerFreezer;
import com.mrcrayfish.furniture.init.FurnitureItems;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.server.gui.IUpdatePlayerListBox;
import net.minecraft.tileentity.TileEntityLockable;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IChatComponent;

public class TileEntityFreezer
extends TileEntityLockable
implements ISidedInventory,
IUpdatePlayerListBox {
    private static final int[] slots_bottom = new int[]{2};
    private static final int[] slots_sides = new int[]{0, 1};
    private ItemStack[] inventory = new ItemStack[3];
    private boolean freezing = false;
    public int progress = 0;
    public int timeRemaining = 0;
    public int fuelTime = 0;

    public void startFreezing() {
        if (this.canFreeze()) {
            if (this.timeRemaining == 0) {
                this.timeRemaining = this.fuelTime = TileEntityFreezer.getFuelTime(this.inventory[0]);
                --this.inventory[0].field_77994_a;
                if (this.inventory[0].field_77994_a <= 0) {
                    this.inventory[0] = null;
                }
            }
            this.freezing = true;
            this.field_145850_b.func_175666_e(this.field_174879_c, this.field_145854_h);
        }
    }

    public void stopFreezing() {
        this.freezing = false;
        this.field_145850_b.func_175666_e(this.field_174879_c, this.field_145854_h);
    }

    public boolean canFreeze() {
        if (this.inventory[0] == null && this.timeRemaining == 0) {
            return false;
        }
        if (this.inventory[0] != null && this.timeRemaining == 0 && !TileEntityFreezer.isFuel(this.inventory[0])) {
            return false;
        }
        if (this.inventory[1] != null) {
            RecipeData data = Recipes.getFreezerRecipeFromInput(this.inventory[1]);
            if (data == null) {
                return false;
            }
            if (this.inventory[2] == null) {
                return true;
            }
            if (this.inventory[2].func_77973_b() != data.getOutput().func_77973_b()) {
                return false;
            }
            if (this.inventory[2].field_77994_a < this.func_70297_j_() && this.inventory[2].field_77994_a < this.inventory[2].func_77976_d()) {
                return true;
            }
        }
        return false;
    }

    public void freezeItem() {
        if (this.inventory[1] != null) {
            RecipeData data = Recipes.getFreezerRecipeFromInput(this.inventory[1]);
            if (data == null) {
                return;
            }
            if (this.inventory[2] == null) {
                this.inventory[2] = data.getOutput().func_77946_l();
            } else if (this.inventory[2].func_77973_b() == data.getOutput().func_77973_b() && this.inventory[2].func_77952_i() == data.getOutput().func_77952_i()) {
                this.inventory[2].field_77994_a += data.getOutput().func_77946_l().field_77994_a;
            }
            if (this.inventory[1].func_77973_b().func_77634_r()) {
                this.inventory[1] = new ItemStack(this.inventory[1].func_77973_b().func_77668_q());
            } else {
                --this.inventory[1].field_77994_a;
            }
            if (this.inventory[1].field_77994_a <= 0) {
                this.inventory[1] = null;
            }
        }
    }

    public boolean isFreezing() {
        return this.freezing;
    }

    public static boolean isFuel(ItemStack stack) {
        return TileEntityFreezer.getFuelTime(stack) > 0;
    }

    private static int getFuelTime(ItemStack stack) {
        if (stack == null) {
            return 0;
        }
        if (stack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150403_cj)) {
            return 3000;
        }
        if (stack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150432_aD)) {
            return 2000;
        }
        if (stack.func_77973_b() == FurnitureItems.itemCoolPack) {
            return 400;
        }
        return 0;
    }

    public void func_73660_a() {
        if (this.freezing) {
            if (!this.canFreeze()) {
                this.freezing = false;
                this.field_145850_b.func_175666_e(this.field_174879_c, this.field_145854_h);
                return;
            }
            ++this.progress;
            if (this.progress >= 200) {
                this.freezeItem();
                this.progress = 0;
            }
            --this.timeRemaining;
            if (this.timeRemaining <= 0) {
                if (this.inventory[0] != null && TileEntityFreezer.isFuel(this.inventory[0])) {
                    this.timeRemaining = this.fuelTime = TileEntityFreezer.getFuelTime(this.inventory[0]);
                    --this.inventory[0].field_77994_a;
                    if (this.inventory[0].field_77994_a <= 0) {
                        this.inventory[0] = null;
                    }
                } else {
                    this.timeRemaining = 0;
                    this.freezing = false;
                    this.field_145850_b.func_175666_e(this.field_174879_c, this.field_145854_h);
                }
            }
        } else if (this.progress > 0) {
            --this.progress;
        }
    }

    public int func_70302_i_() {
        return this.inventory.length;
    }

    public ItemStack func_70301_a(int par1) {
        return this.inventory[par1];
    }

    public ItemStack func_70298_a(int par1, int par2) {
        if (this.inventory[par1] != null) {
            if (this.inventory[par1].field_77994_a <= par2) {
                ItemStack itemstack = this.inventory[par1];
                this.inventory[par1] = null;
                return itemstack;
            }
            ItemStack itemstack = this.inventory[par1].func_77979_a(par2);
            if (this.inventory[par1].field_77994_a == 0) {
                this.inventory[par1] = null;
            }
            return itemstack;
        }
        return null;
    }

    public ItemStack func_70304_b(int par1) {
        if (this.inventory[par1] != null) {
            ItemStack itemstack = this.inventory[par1];
            this.inventory[par1] = null;
            return itemstack;
        }
        return null;
    }

    public void func_70299_a(int par1, ItemStack par2ItemStack) {
        this.inventory[par1] = par2ItemStack;
        if (par2ItemStack != null && par2ItemStack.field_77994_a > this.func_70297_j_()) {
            par2ItemStack.field_77994_a = this.func_70297_j_();
        }
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) != this ? false : entityplayer.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        NBTTagList tagList = (NBTTagList)tagCompound.func_74781_a("Items");
        this.inventory = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound nbt = tagList.func_150305_b(i);
            byte slot = nbt.func_74771_c("Slot");
            if (slot < 0 || slot >= this.inventory.length) continue;
            this.inventory[slot] = ItemStack.func_77949_a((NBTTagCompound)nbt);
        }
        this.freezing = tagCompound.func_74767_n("Freezing");
        this.progress = tagCompound.func_74762_e("Progress");
        this.fuelTime = tagCompound.func_74762_e("FuelTime");
        this.timeRemaining = tagCompound.func_74762_e("Remaining");
    }

    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        NBTTagList tagList = new NBTTagList();
        for (int slot = 0; slot < this.inventory.length; ++slot) {
            if (this.inventory[slot] == null) continue;
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74774_a("Slot", (byte)slot);
            this.inventory[slot].func_77955_b(nbt);
            tagList.func_74742_a((NBTBase)nbt);
        }
        tagCompound.func_74782_a("Items", (NBTBase)tagList);
        tagCompound.func_74757_a("Freezing", this.freezing);
        tagCompound.func_74768_a("Progress", this.progress);
        tagCompound.func_74768_a("FuelTime", this.fuelTime);
        tagCompound.func_74768_a("Remaining", this.timeRemaining);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        NBTTagCompound tagCom = pkt.func_148857_g();
        this.func_145839_a(tagCom);
    }

    public Packet func_145844_m() {
        NBTTagCompound tagCom = new NBTTagCompound();
        this.func_145841_b(tagCom);
        return new S35PacketUpdateTileEntity(this.field_174879_c, this.func_145832_p(), tagCom);
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        for (int i = 0; i < this.inventory.length; ++i) {
            this.inventory[i] = null;
        }
    }

    public String func_70005_c_() {
        return "Freezer";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public IChatComponent func_145748_c_() {
        return null;
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return true;
    }

    public int[] func_180463_a(EnumFacing side) {
        if (side == EnumFacing.DOWN) {
            return slots_bottom;
        }
        return slots_sides;
    }

    public boolean func_180462_a(int slotIn, ItemStack stack, EnumFacing side) {
        if (this.func_174893_q_()) {
            return false;
        }
        if (side != EnumFacing.DOWN) {
            if (slotIn == 0) {
                return TileEntityFreezer.isFuel(stack);
            }
            if (slotIn == 1) {
                return RecipeAPI.getFreezerRecipeFromInput(stack) != null;
            }
        }
        return false;
    }

    public boolean func_180461_b(int slotId, ItemStack stack, EnumFacing side) {
        return side == EnumFacing.DOWN && !this.func_174893_q_();
    }

    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        return new ContainerFreezer((IInventory)playerInventory, (IInventory)this);
    }

    public String func_174875_k() {
        return "0";
    }
}

