/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.tileentity;

import com.mrcrayfish.furniture.api.RecipeAPI;
import com.mrcrayfish.furniture.api.RecipeData;
import com.mrcrayfish.furniture.blocks.BlockGrill;
import com.mrcrayfish.furniture.gui.inventory.ISimpleInventory;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.server.gui.IUpdatePlayerListBox;
import net.minecraft.tileentity.TileEntity;

public class TileEntityGrill
extends TileEntity
implements IUpdatePlayerListBox,
ISimpleInventory {
    public ItemStack[] inventory = new ItemStack[2];
    private static final int COOK_DURATION = 300;
    private static final int COAL_DURATION = 3000;
    public static final int FLIP_DURATION = 20;
    private int coal = 0;
    private int coalTick = 0;
    private boolean fire = false;
    public boolean flippedLeft = false;
    public boolean flippedRight = false;
    public int leftCookTime = 0;
    public int rightCookTime = 0;
    public boolean leftCooked = false;
    public boolean rightCooked = false;
    public int leftFlipCount = 0;
    public float leftCurrentHeight = 0.0f;
    public int rightFlipCount = 0;
    public float rightCurrentHeight = 0.0f;
    public int leftSoundLoop = 0;
    public int rightSoundLoop = 0;

    public boolean addFood(BlockGrill.ClickedSide clickedSide, ItemStack food) {
        if (this.removeFood(clickedSide)) {
            return false;
        }
        if (RecipeAPI.getGrillRecipeFromInput(food) == null) {
            return false;
        }
        if (clickedSide != BlockGrill.ClickedSide.UNKNOWN) {
            this.inventory[clickedSide.id] = new ItemStack(food.func_77973_b(), 1, food.func_77952_i());
            this.field_145850_b.func_175689_h(this.field_174879_c);
            return true;
        }
        return false;
    }

    public boolean removeFood(BlockGrill.ClickedSide clickedSide) {
        if (!this.field_145850_b.field_72995_K && clickedSide.id <= 1 && this.inventory[clickedSide.id] != null) {
            this.resetSide(clickedSide);
            RecipeData data = RecipeAPI.getGrillRecipeFromInput(this.inventory[clickedSide.id]);
            if (this.isCooked(clickedSide) && data != null) {
                this.spawnItem(data.getOutput());
            } else {
                this.spawnItem(this.inventory[clickedSide.id]);
            }
            this.inventory[clickedSide.id] = null;
            this.field_145850_b.func_175689_h(this.func_174877_v());
            return true;
        }
        return false;
    }

    private boolean isFlipped(BlockGrill.ClickedSide side) {
        if (side.id == 0) {
            return this.flippedLeft;
        }
        return this.flippedRight;
    }

    private boolean isCooked(BlockGrill.ClickedSide side) {
        if (!this.isFlipped(side)) {
            return false;
        }
        if (side.id == 0) {
            return this.leftCooked;
        }
        return this.rightCooked;
    }

    private void spawnItem(ItemStack stack) {
        EntityItem entityFood = new EntityItem(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)((float)this.field_174879_c.func_177956_o() + 1.0f), (double)this.field_174879_c.func_177952_p() + 0.5, stack);
        this.field_145850_b.func_72838_d((Entity)entityFood);
    }

    public void flipFood(BlockGrill.ClickedSide clickedSide) {
        if (this.isCooked(clickedSide) && this.removeFood(clickedSide)) {
            return;
        }
        if (this.leftCooked && !this.flippedLeft && clickedSide == BlockGrill.ClickedSide.LEFT) {
            this.leftCooked = false;
            this.leftCookTime = 0;
            this.flippedLeft = true;
            this.leftSoundLoop = 0;
        } else if (this.rightCooked && !this.flippedRight && clickedSide == BlockGrill.ClickedSide.RIGHT) {
            this.rightCooked = false;
            this.rightCookTime = 0;
            this.flippedRight = true;
            this.rightSoundLoop = 0;
        }
        this.field_145850_b.func_175689_h(this.func_174877_v());
    }

    public boolean addCoal() {
        if (this.coal < 3) {
            ++this.coal;
            this.field_145850_b.func_175689_h(this.func_174877_v());
            return true;
        }
        return false;
    }

    public int getCoal() {
        return this.coal;
    }

    public void startFire() {
        if (this.coal > 0) {
            this.fire = true;
        }
        this.field_145850_b.func_175689_h(this.func_174877_v());
    }

    public boolean isFireStarted() {
        return this.fire;
    }

    private void resetSide(BlockGrill.ClickedSide side) {
        if (side == BlockGrill.ClickedSide.LEFT) {
            this.leftCooked = false;
            this.leftCookTime = 0;
            this.flippedLeft = false;
            this.leftSoundLoop = 0;
        } else if (side == BlockGrill.ClickedSide.RIGHT) {
            this.rightCooked = false;
            this.rightCookTime = 0;
            this.flippedRight = false;
            this.rightSoundLoop = 0;
        }
    }

    @Override
    public int getSize() {
        return this.inventory.length;
    }

    @Override
    public ItemStack getItem(int i) {
        if (i < this.getSize()) {
            return this.inventory[i];
        }
        return null;
    }

    @Override
    public void clear() {
        this.inventory[0] = null;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.fire) {
                RecipeData dataRight;
                RecipeData dataLeft;
                if (this.inventory[0] != null && (dataLeft = RecipeAPI.getGrillRecipeFromInput(this.inventory[0])) != null) {
                    if (this.leftCookTime >= 300) {
                        if (!this.leftCooked) {
                            if (this.flippedLeft) {
                                this.inventory[0] = dataLeft.getOutput().func_77946_l();
                            }
                            this.leftCooked = true;
                            this.field_145850_b.func_175689_h(this.func_174877_v());
                            this.leftSoundLoop = 0;
                        }
                        if (this.leftSoundLoop % 20 == 0) {
                            this.field_145850_b.func_72908_a((double)this.field_174879_c.func_177958_n() + 0.5, (double)(this.field_174879_c.func_177956_o() + 1), (double)this.field_174879_c.func_177952_p() + 0.5, "cfm:sizzle", 1.0f, 0.5f);
                        }
                    } else {
                        if (this.leftSoundLoop % 20 == 0 && !this.leftCooked) {
                            if (this.flippedLeft && this.leftCookTime >= 20) {
                                this.field_145850_b.func_72908_a((double)this.field_174879_c.func_177958_n() + 0.5, (double)(this.field_174879_c.func_177956_o() + 1), (double)this.field_174879_c.func_177952_p() + 0.5, "cfm:sizzle", 1.0f, 1.0f);
                            } else if (!this.flippedLeft) {
                                this.field_145850_b.func_72908_a((double)this.field_174879_c.func_177958_n() + 0.5, (double)(this.field_174879_c.func_177956_o() + 1), (double)this.field_174879_c.func_177952_p() + 0.5, "cfm:sizzle", 1.0f, 1.0f);
                            }
                        }
                        ++this.leftCookTime;
                    }
                    ++this.leftSoundLoop;
                }
                if (this.inventory[1] != null && (dataRight = RecipeAPI.getGrillRecipeFromInput(this.inventory[1])) != null) {
                    if (this.rightCookTime >= 300) {
                        if (!this.rightCooked) {
                            if (this.flippedRight) {
                                this.inventory[1] = dataRight.getOutput().func_77946_l();
                            }
                            this.rightCooked = true;
                            this.field_145850_b.func_175689_h(this.func_174877_v());
                            this.rightSoundLoop = 0;
                        }
                        if (this.rightSoundLoop % 20 == 0) {
                            this.field_145850_b.func_72908_a((double)this.field_174879_c.func_177958_n() + 0.5, (double)(this.field_174879_c.func_177956_o() + 1), (double)this.field_174879_c.func_177952_p() + 0.5, "cfm:sizzle", 1.0f, 0.5f);
                        }
                    } else {
                        if (this.rightSoundLoop % 20 == 0 && !this.rightCooked) {
                            if (this.flippedRight && this.rightCookTime >= 20) {
                                this.field_145850_b.func_72908_a((double)this.field_174879_c.func_177958_n() + 0.5, (double)(this.field_174879_c.func_177956_o() + 1), (double)this.field_174879_c.func_177952_p() + 0.5, "cfm:sizzle", 1.0f, 1.0f);
                            } else if (!this.flippedRight) {
                                this.field_145850_b.func_72908_a((double)this.field_174879_c.func_177958_n() + 0.5, (double)(this.field_174879_c.func_177956_o() + 1), (double)this.field_174879_c.func_177952_p() + 0.5, "cfm:sizzle", 1.0f, 1.0f);
                            }
                        }
                        ++this.rightCookTime;
                    }
                    ++this.rightSoundLoop;
                }
                ++this.coalTick;
                if (this.coalTick >= 3000) {
                    this.coalTick = 0;
                    --this.coal;
                    if (this.coal <= 0) {
                        this.fire = false;
                    }
                    this.field_145850_b.func_175689_h(this.func_174877_v());
                }
            }
        } else {
            if (this.flippedLeft && this.leftFlipCount < 20) {
                ++this.leftFlipCount;
            }
            if (this.flippedRight && this.rightFlipCount < 20) {
                ++this.rightFlipCount;
            }
        }
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (compound.func_74764_b("Items")) {
            NBTTagList tagList = (NBTTagList)compound.func_74781_a("Items");
            this.inventory = new ItemStack[6];
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                NBTTagCompound nbt = tagList.func_150305_b(i);
                byte slot = nbt.func_74771_c("Slot");
                if (slot < 0 || slot >= this.inventory.length) continue;
                this.inventory[slot] = ItemStack.func_77949_a((NBTTagCompound)nbt);
            }
        }
        this.fire = compound.func_74767_n("fire");
        this.coal = compound.func_74762_e("coal");
        this.coalTick = compound.func_74762_e("coalTick");
        this.flippedLeft = compound.func_74767_n("flipLeft");
        this.flippedRight = compound.func_74767_n("flipRight");
        this.leftCookTime = compound.func_74762_e("leftCookTime");
        this.rightCookTime = compound.func_74762_e("rightCookTime");
        this.leftCooked = compound.func_74767_n("leftCooked");
        this.rightCooked = compound.func_74767_n("rightCooked");
    }

    public void func_145841_b(NBTTagCompound compound) {
        super.func_145841_b(compound);
        NBTTagList tagList = new NBTTagList();
        for (int slot = 0; slot < this.inventory.length; ++slot) {
            if (this.inventory[slot] == null) continue;
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74774_a("Slot", (byte)slot);
            this.inventory[slot].func_77955_b(nbt);
            tagList.func_74742_a((NBTBase)nbt);
        }
        compound.func_74782_a("Items", (NBTBase)tagList);
        compound.func_74757_a("fire", this.fire);
        compound.func_74768_a("coal", this.coal);
        compound.func_74768_a("coalTick", this.coalTick);
        compound.func_74757_a("flipLeft", this.flippedLeft);
        compound.func_74757_a("flipRight", this.flippedRight);
        compound.func_74768_a("leftCookTime", this.leftCookTime);
        compound.func_74768_a("rightCookTime", this.rightCookTime);
        compound.func_74757_a("leftCooked", this.leftCooked);
        compound.func_74757_a("rightCooked", this.rightCooked);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        NBTTagCompound tagCom = pkt.func_148857_g();
        this.func_145839_a(tagCom);
    }

    public Packet func_145844_m() {
        NBTTagCompound tagCom = new NBTTagCompound();
        this.func_145841_b(tagCom);
        return new S35PacketUpdateTileEntity(this.field_174879_c, this.func_145832_p(), tagCom);
    }
}

