/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.cmdcam.command;

import com.creativemd.cmdcam.CMDCam;
import com.creativemd.cmdcam.CamEventHandler;
import com.creativemd.cmdcam.movement.Movement;
import com.creativemd.cmdcam.utils.CamPoint;
import com.mojang.realmsclient.gui.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;

public class CamCommand
extends CommandBase {
    public static Minecraft mc = Minecraft.func_71410_x();

    public String func_71517_b() {
        return "cam";
    }

    public String func_71518_a(ICommandSender sender) {
        return "used to control the camera";
    }

    public int func_82362_a() {
        return 0;
    }

    public static long StringToDuration(String input) {
        String replacement = null;
        int factor = 0;
        if (input.endsWith("ms")) {
            replacement = "ms";
            factor = 1;
        } else if (input.endsWith("s")) {
            replacement = "s";
            factor = 1000;
        } else if (input.endsWith("m")) {
            replacement = "m";
            factor = 60000;
        } else if (input.endsWith("h")) {
            replacement = "h";
            factor = 3600000;
        } else if (input.endsWith("d")) {
            replacement = "d";
            factor = 86400000;
        }
        try {
            if (replacement == null) {
                replacement = "";
                factor = 1000;
            }
            return Long.parseLong(input.replaceAll(replacement, "")) * (long)factor;
        }
        catch (Exception exception) {
            return -1L;
        }
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length == 0) {
            sender.func_145747_a((ITextComponent)new TextComponentString("" + ChatFormatting.BOLD + ChatFormatting.YELLOW + "/cam add [number] " + ChatFormatting.RED + "register a point at the current position"));
            sender.func_145747_a((ITextComponent)new TextComponentString("" + ChatFormatting.BOLD + ChatFormatting.YELLOW + "/cam clear " + ChatFormatting.RED + "delete all registered points"));
            sender.func_145747_a((ITextComponent)new TextComponentString("" + ChatFormatting.BOLD + ChatFormatting.YELLOW + "/cam start <time|ms|s|m|h|d> " + ChatFormatting.RED + "starts the animation"));
            sender.func_145747_a((ITextComponent)new TextComponentString("" + ChatFormatting.BOLD + ChatFormatting.YELLOW + "/cam goto <index> " + ChatFormatting.RED + "tp to the given point"));
            sender.func_145747_a((ITextComponent)new TextComponentString("" + ChatFormatting.BOLD + ChatFormatting.YELLOW + "/cam set <index> " + ChatFormatting.RED + "updates point to current location"));
            sender.func_145747_a((ITextComponent)new TextComponentString("" + ChatFormatting.BOLD + ChatFormatting.YELLOW + "/cam remove <index> " + ChatFormatting.RED + "removes the given point"));
            sender.func_145747_a((ITextComponent)new TextComponentString("" + ChatFormatting.BOLD + ChatFormatting.YELLOW + "/cam target <none:self> " + ChatFormatting.RED + "set the camera target"));
            sender.func_145747_a((ITextComponent)new TextComponentString("" + ChatFormatting.BOLD + ChatFormatting.YELLOW + "/cam mode <default:outside> " + ChatFormatting.RED + "set current mode"));
            sender.func_145747_a((ITextComponent)new TextComponentString("" + ChatFormatting.BOLD + ChatFormatting.YELLOW + "/cam interpolation <" + String.join((CharSequence)":", Movement.getMovementNames()) + "> " + ChatFormatting.RED + "set the camera interpolation"));
            sender.func_145747_a((ITextComponent)new TextComponentString("" + ChatFormatting.BOLD + ChatFormatting.YELLOW + "/cam follow-speed <number> " + ChatFormatting.RED + "default is 1.0"));
            sender.func_145747_a((ITextComponent)new TextComponentString("" + ChatFormatting.BOLD + ChatFormatting.YELLOW + "/cam show <all:" + String.join((CharSequence)":", Movement.getMovementNames()) + "> " + ChatFormatting.RED + "shows the path using the given interpolation"));
            sender.func_145747_a((ITextComponent)new TextComponentString("" + ChatFormatting.BOLD + ChatFormatting.YELLOW + "/cam hide <all:" + String.join((CharSequence)":", Movement.getMovementNames()) + "> " + ChatFormatting.RED + "hides the path using the given interpolation"));
        } else {
            Movement move;
            String subCommand;
            block74: {
                block73: {
                    block72: {
                        block71: {
                            subCommand = args[0];
                            if (subCommand.equals("clear")) {
                                sender.func_145747_a((ITextComponent)new TextComponentString("Cleared all registered points!"));
                                CMDCam.points.clear();
                            }
                            if (subCommand.equals("add")) {
                                if (args.length == 1) {
                                    CMDCam.points.add(new CamPoint());
                                    sender.func_145747_a((ITextComponent)new TextComponentString("Registered " + CMDCam.points.size() + ". Point!"));
                                } else if (args.length == 2) {
                                    try {
                                        Integer index = Integer.parseInt(args[1]) - 1;
                                        if (index >= 0 && index < CMDCam.points.size()) {
                                            CMDCam.points.add(index, new CamPoint());
                                            sender.func_145747_a((ITextComponent)new TextComponentString("Inserted " + index + ". Point!"));
                                            break block71;
                                        }
                                        sender.func_145747_a((ITextComponent)new TextComponentString("The given index '" + args[1] + "' is too high/low!"));
                                    }
                                    catch (Exception e) {
                                        sender.func_145747_a((ITextComponent)new TextComponentString("Invalid index '" + args[1] + "'!"));
                                    }
                                } else {
                                    sender.func_145747_a((ITextComponent)new TextComponentString("" + ChatFormatting.BOLD + ChatFormatting.YELLOW + "/cam add [number] " + ChatFormatting.RED + "register a point at the current position."));
                                }
                            }
                        }
                        if (subCommand.equals("start")) {
                            if (args.length >= 2) {
                                long duration = CamCommand.StringToDuration(args[1]);
                                if (duration > 0L) {
                                    CMDCam.lastDuration = duration;
                                } else {
                                    sender.func_145747_a((ITextComponent)new TextComponentString("Invalid time '" + args[1] + "'!"));
                                    return;
                                }
                            }
                            CMDCam.createPath();
                        }
                        if (subCommand.equals("remove")) {
                            if (args.length >= 2) {
                                try {
                                    Integer index = Integer.parseInt(args[1]) - 1;
                                    if (index >= 0 && index < CMDCam.points.size()) {
                                        CMDCam.points.remove(index);
                                        sender.func_145747_a((ITextComponent)new TextComponentString("Removed " + (index + 1) + ". point!"));
                                        break block72;
                                    }
                                    sender.func_145747_a((ITextComponent)new TextComponentString("The given index '" + args[1] + "' is too high/low!"));
                                }
                                catch (Exception e) {
                                    sender.func_145747_a((ITextComponent)new TextComponentString("Invalid index '" + args[1] + "'!"));
                                }
                            } else {
                                sender.func_145747_a((ITextComponent)new TextComponentString("" + ChatFormatting.BOLD + ChatFormatting.YELLOW + "/cam remove <index> " + ChatFormatting.RED + "removes the given point"));
                            }
                        }
                    }
                    if (subCommand.equals("set")) {
                        if (args.length >= 2) {
                            try {
                                Integer index = Integer.parseInt(args[1]) - 1;
                                if (index >= 0 && index < CMDCam.points.size()) {
                                    CMDCam.points.set(index, new CamPoint());
                                    sender.func_145747_a((ITextComponent)new TextComponentString("Updated " + (index + 1) + ". point!"));
                                    break block73;
                                }
                                sender.func_145747_a((ITextComponent)new TextComponentString("The given index '" + args[1] + "' is too high/low!"));
                            }
                            catch (Exception e) {
                                sender.func_145747_a((ITextComponent)new TextComponentString("Invalid index '" + args[1] + "'!"));
                            }
                        } else {
                            sender.func_145747_a((ITextComponent)new TextComponentString("" + ChatFormatting.BOLD + ChatFormatting.YELLOW + "/cam set <index> " + ChatFormatting.RED + "updates the giveng point to the current location"));
                        }
                    }
                }
                if (subCommand.equals("goto")) {
                    if (args.length >= 2) {
                        try {
                            Integer index = Integer.parseInt(args[1]) - 1;
                            if (index >= 0 && index < CMDCam.points.size()) {
                                CamPoint point = CMDCam.points.get(index);
                                CamCommand.mc.field_71439_g.field_71075_bZ.field_75100_b = true;
                                CMDCam.roll = (float)point.roll;
                                CamCommand.mc.field_71474_y.field_74334_X = (float)point.zoom;
                                CamCommand.mc.field_71439_g.func_70080_a(point.x, point.y, point.z, (float)point.rotationYaw, (float)point.rotationPitch);
                                CamCommand.mc.field_71439_g.func_70012_b(point.x, point.y, point.z, (float)point.rotationYaw, (float)point.rotationPitch);
                                break block74;
                            }
                            sender.func_145747_a((ITextComponent)new TextComponentString("The given index '" + args[1] + "' is too high/low!"));
                        }
                        catch (Exception e) {
                            sender.func_145747_a((ITextComponent)new TextComponentString("Invalid index '" + args[1] + "'!"));
                        }
                    } else {
                        sender.func_145747_a((ITextComponent)new TextComponentString("Missing point!"));
                        sender.func_145747_a((ITextComponent)new TextComponentString("" + ChatFormatting.BOLD + ChatFormatting.YELLOW + "/cam goto <index> " + ChatFormatting.RED + "tp to the given point"));
                    }
                }
            }
            if (subCommand.equals("mode")) {
                if (args.length >= 2) {
                    if (args[1].equals("default") || args[1].equals("outside")) {
                        CMDCam.lastPath = args[1];
                        sender.func_145747_a((ITextComponent)new TextComponentString("Changed to " + args[1] + " path!"));
                    } else {
                        sender.func_145747_a((ITextComponent)new TextComponentString("Path mode '" + args[1] + "' does not exit!"));
                    }
                } else {
                    sender.func_145747_a((ITextComponent)new TextComponentString("" + ChatFormatting.BOLD + ChatFormatting.YELLOW + "/cam mode <default:outside> " + ChatFormatting.RED + "set current mode"));
                }
            }
            if (subCommand.equals("target")) {
                if (args.length == 2) {
                    String target = args[1];
                    if (target.equals("self")) {
                        CMDCam.target = "self";
                        sender.func_145747_a((ITextComponent)new TextComponentString("The camera will point towards you!"));
                    } else if (target.equals("none")) {
                        CMDCam.target = null;
                        sender.func_145747_a((ITextComponent)new TextComponentString("Removed target!"));
                    } else {
                        sender.func_145747_a((ITextComponent)new TextComponentString("Target '" + target + "' not found!"));
                    }
                } else {
                    CamEventHandler.selectEntityMode = true;
                    sender.func_145747_a((ITextComponent)new TextComponentString("Please select a target either an entity or a block!"));
                }
            }
            if (subCommand.equals("interpolation")) {
                if (args.length == 2) {
                    String target = args[1];
                    move = Movement.getMovementById(target);
                    if (move != null) {
                        CMDCam.lastMovement = target;
                        sender.func_145747_a((ITextComponent)new TextComponentString("Interpolation is set to '" + target + "'!"));
                    } else {
                        sender.func_145747_a((ITextComponent)new TextComponentString("Interpolation '" + target + "' not found!"));
                    }
                } else {
                    sender.func_145747_a((ITextComponent)new TextComponentString("" + ChatFormatting.BOLD + ChatFormatting.YELLOW + "/cam interpolation <" + String.join((CharSequence)":", Movement.getMovementNames()) + "> " + ChatFormatting.RED + "set the camera interpolation"));
                }
            }
            if (subCommand.equals("follow-speed")) {
                if (args.length == 2) {
                    try {
                        double followspeed;
                        CMDCam.cameraFollowSpeed = followspeed = Double.parseDouble(args[1]);
                        sender.func_145747_a((ITextComponent)new TextComponentString("Camera follow speed is set to  '" + followspeed + "'. Default is 1.0!"));
                    }
                    catch (NumberFormatException e) {
                        sender.func_145747_a((ITextComponent)new TextComponentString("'" + args[1] + "' is an invalid number!"));
                    }
                } else {
                    sender.func_145747_a((ITextComponent)new TextComponentString("" + ChatFormatting.BOLD + ChatFormatting.YELLOW + "/cam follow-speed <number> " + ChatFormatting.RED + "default is 1.0"));
                }
            }
            if (subCommand.equals("show")) {
                if (args.length == 2) {
                    String target = args[1];
                    move = Movement.getMovementById(target);
                    if (move != null) {
                        move.isRenderingEnabled = true;
                        sender.func_145747_a((ITextComponent)new TextComponentString("Showing '" + target + "' interpolation path!"));
                    } else if (target.equals("all")) {
                        for (Movement movement : Movement.movements.values()) {
                            movement.isRenderingEnabled = true;
                        }
                        sender.func_145747_a((ITextComponent)new TextComponentString("Showing all interpolation paths!"));
                    } else {
                        sender.func_145747_a((ITextComponent)new TextComponentString("Interpolation '" + target + "' not found!"));
                    }
                } else {
                    sender.func_145747_a((ITextComponent)new TextComponentString("" + ChatFormatting.BOLD + ChatFormatting.YELLOW + "/cam show <all:" + String.join((CharSequence)":", Movement.getMovementNames()) + "> " + ChatFormatting.RED + "shows the path using the given interpolation"));
                }
            }
            if (subCommand.equals("hide")) {
                if (args.length == 2) {
                    String target = args[1];
                    move = Movement.getMovementById(target);
                    if (move != null) {
                        move.isRenderingEnabled = false;
                        sender.func_145747_a((ITextComponent)new TextComponentString("Hiding '" + target + "' interpolation path!"));
                    } else if (target.equals("all")) {
                        for (Movement movement : Movement.movements.values()) {
                            movement.isRenderingEnabled = false;
                        }
                        sender.func_145747_a((ITextComponent)new TextComponentString("Hiding all interpolation paths!"));
                    } else {
                        sender.func_145747_a((ITextComponent)new TextComponentString("Interpolation '" + target + "' not found!"));
                    }
                } else {
                    sender.func_145747_a((ITextComponent)new TextComponentString("" + ChatFormatting.BOLD + ChatFormatting.YELLOW + "/cam hide <all:" + String.join((CharSequence)":", Movement.getMovementNames()) + "> " + ChatFormatting.RED + "hides the path using the given interpolation"));
                }
            }
        }
    }
}

