/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.cmdcam.movement;

import com.creativemd.cmdcam.CMDCam;
import com.creativemd.cmdcam.CamEventHandler;
import com.creativemd.cmdcam.movement.DefaultPath;
import com.creativemd.cmdcam.movement.Movement;
import com.creativemd.cmdcam.movement.OutsidePath;
import com.creativemd.cmdcam.utils.CamPoint;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;

public abstract class Path {
    public static HashMap<String, Path> paths = new HashMap();
    public long started = System.currentTimeMillis();
    public long duration;
    public Movement movement;
    public boolean hideGui;
    public Object target;
    public double lastYaw;
    public double lastPitch;
    public boolean isFirst = true;
    public ArrayList<CamPoint> points = new ArrayList();
    public static Minecraft mc = Minecraft.func_71410_x();

    public static void registerPath(String name, Path path) {
        paths.put(name, path);
    }

    public static Path getPathById(String lastPath) {
        return paths.get(lastPath);
    }

    public static void initPaths() {
        Path.registerPath("default", new DefaultPath(null, 0L, null, null));
        Path.registerPath("outside", new OutsidePath(null, 0L, null, null));
    }

    public Path(ArrayList<CamPoint> points, long duration, Movement movement, Object target) {
        this.points = points;
        this.duration = duration;
        this.movement = movement;
        if (points != null) {
            this.hideGui = Path.mc.field_71474_y.field_74319_N;
            this.lastPitch = points.get((int)0).rotationPitch;
            this.lastYaw = points.get((int)0).rotationYaw;
        }
        this.target = target;
    }

    public abstract Path createPath(ArrayList<CamPoint> var1, long var2, Movement var4, Object var5);

    public CamPoint getCamPoint(CamPoint point1, CamPoint point2, double percent, double wholeProgress, float renderTickTime) {
        CamPoint newPoint = this.movement.getPointInBetween(point1, point2, percent, wholeProgress);
        if (this.target != null) {
            newPoint.rotationPitch = this.lastPitch;
            newPoint.rotationYaw = this.lastYaw;
            Vec3d pos = null;
            if (this.target instanceof Entity) {
                pos = ((Entity)this.target).func_174824_e(renderTickTime);
                pos = this.target instanceof EntityLivingBase ? ((EntityLivingBase)this.target).func_174824_e(renderTickTime).func_178788_d(new Vec3d(0.0, (double)((EntityLivingBase)this.target).func_70047_e(), 0.0)) : ((Entity)this.target).func_174824_e(renderTickTime);
            }
            if (this.target instanceof BlockPos) {
                pos = new Vec3d((Vec3i)((BlockPos)this.target));
            }
            if (pos != null) {
                long timeSinceLastRenderFrame = System.nanoTime() - CamEventHandler.lastRenderTime;
                newPoint.faceEntity(pos, 1.0E-8f, 1.0E-8f, (double)timeSinceLastRenderFrame / 6.0E8 * CMDCam.cameraFollowSpeed);
            }
            this.lastPitch = newPoint.rotationPitch;
            this.lastYaw = newPoint.rotationYaw;
        }
        return newPoint;
    }

    public void onPathStart() {
    }

    public EntityLivingBase getCamera() {
        return Path.mc.field_71439_g;
    }

    public void tick(float renderTickTime) {
        long time;
        if (this.isFirst) {
            this.onPathStart();
            this.isFirst = false;
        }
        if ((time = System.currentTimeMillis() - this.started) >= this.duration) {
            CMDCam.currentPath = null;
            this.onPathFinished();
            try {
                this.finalize();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            System.out.println("Finished Path");
        } else {
            double percent;
            CamPoint point2;
            long durationOfPoint = this.duration / (long)(this.points.size() - 1);
            int currentPoint = Math.min((int)(time / durationOfPoint), this.points.size() - 2);
            CamPoint point1 = this.points.get(currentPoint);
            CamPoint newPoint = this.getCamPoint(point1, point2 = this.points.get(currentPoint + 1), percent = (double)(time % durationOfPoint) / (double)durationOfPoint, (double)time / (double)this.duration, renderTickTime);
            if (newPoint != null) {
                this.processPoint(newPoint);
            }
        }
    }

    public abstract String getDescription();

    public void processPoint(CamPoint point) {
        Path.mc.field_71474_y.field_74319_N = true;
        CMDCam.roll = (float)point.roll;
        Path.mc.field_71474_y.field_74334_X = (float)point.zoom;
    }

    public void onPathFinished() {
        Path.mc.field_71474_y.field_74319_N = this.hideGui;
        CMDCam.fov = CamEventHandler.defaultfov;
        Path.mc.field_71474_y.field_74334_X = CamEventHandler.defaultfov;
        CMDCam.roll = 0.0f;
    }
}

