/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.cmdcam.movement;

import com.creativemd.cmdcam.movement.Movement;
import com.creativemd.cmdcam.utils.CamPoint;
import com.creativemd.cmdcam.utils.interpolation.CubicInterpolation;
import com.creativemd.cmdcam.utils.interpolation.Vec;
import com.creativemd.cmdcam.utils.interpolation.Vec1;
import com.creativemd.cmdcam.utils.interpolation.Vec3;
import java.util.ArrayList;

public class CubicMovement
extends Movement {
    public CubicInterpolation<Vec1> rollSpline;
    public CubicInterpolation<Vec1> zoomSpline;
    public CubicInterpolation<Vec1> pitchSpline;
    public CubicInterpolation<Vec1> yawSpline;
    public CubicInterpolation<Vec3> positionSpline;
    public double sizeOfIteration;

    @Override
    public void initMovement(ArrayList<CamPoint> points, int loops, Object target) throws Movement.MovementParseException {
        if (points.size() == 1) {
            throw new Movement.MovementParseException("At least two points are required");
        }
        int iterations = loops == 0 ? 1 : (loops == 1 ? 2 : 3);
        this.sizeOfIteration = 1.0 / (double)iterations;
        int size = points.size() * iterations;
        if (iterations > 1) {
            ++size;
        }
        Vec[] rollPoints = new Vec1[size];
        Vec[] zoomPoints = new Vec1[size];
        Vec[] yawPoints = new Vec1[size];
        Vec[] pitchPoints = new Vec1[size];
        Vec[] positionPoints = new Vec3[points.size() * iterations];
        for (int j = 0; j < iterations; ++j) {
            for (int i = 0; i < points.size(); ++i) {
                rollPoints[i + j * points.size()] = new Vec1(points.get((int)i).roll);
                zoomPoints[i + j * points.size()] = new Vec1(points.get((int)i).zoom);
                yawPoints[i + j * points.size()] = new Vec1(points.get((int)i).rotationYaw);
                pitchPoints[i + j * points.size()] = new Vec1(points.get((int)i).rotationPitch);
                positionPoints[i + j * points.size()] = new Vec3(points.get((int)i).x, points.get((int)i).y, points.get((int)i).z);
            }
        }
        if (iterations > 1) {
            rollPoints[points.size() * iterations] = new Vec1(points.get((int)0).roll);
            zoomPoints[points.size() * iterations] = new Vec1(points.get((int)0).zoom);
            yawPoints[points.size() * iterations] = new Vec1(points.get((int)0).rotationYaw);
            pitchPoints[points.size() * iterations] = new Vec1(points.get((int)0).rotationPitch);
            positionPoints[points.size() * iterations] = new Vec3(points.get((int)0).x, points.get((int)0).y, points.get((int)0).z);
        }
        this.rollSpline = new CubicInterpolation(rollPoints);
        this.zoomSpline = new CubicInterpolation(zoomPoints);
        this.pitchSpline = new CubicInterpolation(pitchPoints);
        this.yawSpline = new CubicInterpolation(yawPoints);
        this.positionSpline = new CubicInterpolation(positionPoints);
    }

    @Override
    public CamPoint getPointInBetween(CamPoint point1, CamPoint point2, double percent, double wholeProgress, boolean isFirstLoop, boolean isLastLoop) {
        CamPoint point = point1.getPointBetween(point2, percent);
        int iteration = isFirstLoop ? 0 : (isLastLoop && this.sizeOfIteration < 0.5 ? 2 : 1);
        double additionalProgress = (double)iteration * this.sizeOfIteration;
        wholeProgress = additionalProgress + wholeProgress * this.sizeOfIteration;
        if (this.rollSpline != null) {
            point.roll = ((Vec1)this.rollSpline.valueAt((double)wholeProgress)).x;
        }
        if (this.zoomSpline != null) {
            point.zoom = ((Vec1)this.zoomSpline.valueAt((double)wholeProgress)).x;
        }
        if (this.yawSpline != null) {
            point.rotationYaw = ((Vec1)this.yawSpline.valueAt((double)wholeProgress)).x;
        }
        if (this.pitchSpline != null) {
            point.rotationPitch = ((Vec1)this.pitchSpline.valueAt((double)wholeProgress)).x;
        }
        if (this.positionSpline != null) {
            Vec3 position = (Vec3)this.positionSpline.valueAt(wholeProgress);
            point.x = position.x;
            point.y = position.y;
            point.z = position.z;
        }
        return point;
    }

    @Override
    public Vec3 getColor() {
        return new Vec3(1.0, 0.0, 0.0);
    }
}

