/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.cmdcam.movement;

import com.creativemd.cmdcam.movement.Movement;
import com.creativemd.cmdcam.utils.CamPoint;
import com.creativemd.cmdcam.utils.interpolation.HermiteInterpolation;
import com.creativemd.cmdcam.utils.interpolation.Vec;
import com.creativemd.cmdcam.utils.interpolation.Vec1;
import com.creativemd.cmdcam.utils.interpolation.Vec3;
import java.util.ArrayList;

public class HermiteMovement
extends Movement {
    public HermiteInterpolation<Vec1> rollSpline;
    public HermiteInterpolation<Vec1> zoomSpline;
    public HermiteInterpolation<Vec1> pitchSpline;
    public HermiteInterpolation<Vec1> yawSpline;
    public HermiteInterpolation<Vec3> positionSpline;
    public double sizeOfIteration;

    @Override
    public void initMovement(ArrayList<CamPoint> points, int loops, Object target) throws Movement.MovementParseException {
        this.initMovement(null, points, loops, target);
    }

    public void initMovement(Double[] times, ArrayList<CamPoint> points, int loops, Object target) throws Movement.MovementParseException {
        if (points.size() == 1) {
            throw new Movement.MovementParseException("At least two points are required");
        }
        int iterations = loops == 0 ? 1 : (loops == 1 ? 2 : 3);
        this.sizeOfIteration = 1.0 / (double)iterations;
        int size = points.size() * iterations;
        if (iterations > 1) {
            ++size;
        }
        Vec[] rollPoints = new Vec1[size];
        Vec[] zoomPoints = new Vec1[size];
        Vec[] yawPoints = new Vec1[size];
        Vec[] pitchPoints = new Vec1[size];
        Vec[] positionPoints = new Vec3[size];
        Double[] newTimes = new Double[size];
        for (int j = 0; j < iterations; ++j) {
            int i;
            if (times != null) {
                for (i = 0; i < times.length; ++i) {
                    int index = i + points.size() * j;
                    if (index >= size) continue;
                    newTimes[index] = times[i] * this.sizeOfIteration + this.sizeOfIteration * (double)j;
                }
            }
            for (i = 0; i < points.size(); ++i) {
                rollPoints[i + j * points.size()] = new Vec1(points.get((int)i).roll);
                zoomPoints[i + j * points.size()] = new Vec1(points.get((int)i).zoom);
                yawPoints[i + j * points.size()] = new Vec1(points.get((int)i).rotationYaw);
                pitchPoints[i + j * points.size()] = new Vec1(points.get((int)i).rotationPitch);
                positionPoints[i + j * points.size()] = new Vec3(points.get((int)i).x, points.get((int)i).y, points.get((int)i).z);
            }
        }
        if (iterations > 1) {
            rollPoints[points.size() * iterations] = new Vec1(points.get((int)0).roll);
            zoomPoints[points.size() * iterations] = new Vec1(points.get((int)0).zoom);
            yawPoints[points.size() * iterations] = new Vec1(points.get((int)0).rotationYaw);
            pitchPoints[points.size() * iterations] = new Vec1(points.get((int)0).rotationPitch);
            positionPoints[points.size() * iterations] = new Vec3(points.get((int)0).x, points.get((int)0).y, points.get((int)0).z);
        }
        if (times == null) {
            this.rollSpline = new HermiteInterpolation(rollPoints);
            this.zoomSpline = new HermiteInterpolation(zoomPoints);
            this.pitchSpline = new HermiteInterpolation(pitchPoints);
            this.yawSpline = new HermiteInterpolation(yawPoints);
            this.positionSpline = new HermiteInterpolation(HermiteInterpolation.Tension.Normal, positionPoints);
        } else {
            this.rollSpline = new HermiteInterpolation(newTimes, rollPoints);
            this.zoomSpline = new HermiteInterpolation(newTimes, zoomPoints);
            this.pitchSpline = new HermiteInterpolation(newTimes, pitchPoints);
            this.yawSpline = new HermiteInterpolation(newTimes, yawPoints);
            this.positionSpline = new HermiteInterpolation(HermiteInterpolation.Tension.Normal, positionPoints);
        }
    }

    @Override
    public CamPoint getPointInBetween(CamPoint point1, CamPoint point2, double percent, double wholeProgress, boolean isFirstLoop, boolean isLastLoop) {
        CamPoint point = point1.getPointBetween(point2, percent);
        int iteration = isFirstLoop ? 0 : (isLastLoop && this.sizeOfIteration < 0.5 ? 2 : 1);
        double additionalProgress = (double)iteration * this.sizeOfIteration;
        wholeProgress = additionalProgress + wholeProgress * this.sizeOfIteration;
        if (this.rollSpline != null) {
            point.roll = ((Vec1)this.rollSpline.valueAt((double)wholeProgress)).x;
        }
        if (this.zoomSpline != null) {
            point.zoom = ((Vec1)this.zoomSpline.valueAt((double)wholeProgress)).x;
        }
        if (this.yawSpline != null) {
            point.rotationYaw = ((Vec1)this.yawSpline.valueAt((double)wholeProgress)).x;
        }
        if (this.pitchSpline != null) {
            point.rotationPitch = ((Vec1)this.pitchSpline.valueAt((double)wholeProgress)).x;
        }
        if (this.positionSpline != null) {
            Vec3 position = (Vec3)this.positionSpline.valueAt(wholeProgress);
            point.x = position.x;
            point.y = position.y;
            point.z = position.z;
        }
        return point;
    }

    @Override
    public Vec3 getColor() {
        return new Vec3(1.0, 1.0, 1.0);
    }
}

