/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.cmdcam.movement;

import com.creativemd.cmdcam.movement.CircularMovement;
import com.creativemd.cmdcam.movement.CubicMovement;
import com.creativemd.cmdcam.movement.HermiteMovement;
import com.creativemd.cmdcam.movement.LinearMovement;
import com.creativemd.cmdcam.movement.SmoothMovement;
import com.creativemd.cmdcam.utils.CamPoint;
import com.creativemd.cmdcam.utils.interpolation.Vec3;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public abstract class Movement {
    public static HashMap<String, Movement> movements = new HashMap();
    public static LinearMovement linear = new LinearMovement();
    public static SmoothMovement cosine = new SmoothMovement();
    public static CubicMovement cubic = new CubicMovement();
    public static HermiteMovement hermite = new HermiteMovement();
    public static CircularMovement circular = new CircularMovement();
    public boolean isRenderingEnabled = false;

    public static Movement getMovementById(String lastMovement) {
        return movements.get(lastMovement);
    }

    public static void registerMovement(String name, Movement movement) {
        movements.put(name, movement);
    }

    public static void initMovements() {
        Movement.registerMovement("linear", linear);
        Movement.registerMovement("cubic", cubic);
        Movement.registerMovement("hermite", hermite);
        Movement.registerMovement("cosine", cosine);
        Movement.registerMovement("circular", circular);
    }

    public static String[] getMovementNames() {
        String[] names = new String[movements.size()];
        int i = 0;
        Iterator<String> iterator = movements.keySet().iterator();
        while (iterator.hasNext()) {
            String name;
            names[i] = name = iterator.next();
            ++i;
        }
        return names;
    }

    public abstract Vec3 getColor();

    public abstract void initMovement(ArrayList<CamPoint> var1, int var2, Object var3) throws MovementParseException;

    public abstract CamPoint getPointInBetween(CamPoint var1, CamPoint var2, double var3, double var5, boolean var7, boolean var8);

    public static class MovementParseException
    extends Exception {
        public MovementParseException(String msg) {
            super(msg);
        }
    }
}

