/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.cmdcam.movement;

import com.creativemd.cmdcam.CMDCam;
import com.creativemd.cmdcam.CamEventHandler;
import com.creativemd.cmdcam.movement.DefaultPath;
import com.creativemd.cmdcam.movement.Movement;
import com.creativemd.cmdcam.movement.OutsidePath;
import com.creativemd.cmdcam.utils.CamPoint;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;

public abstract class Path {
    public static HashMap<String, Path> paths = new HashMap();
    public long started = System.currentTimeMillis();
    public long duration;
    public Movement movement;
    public boolean hideGui;
    public Object target;
    public double lastYaw;
    public double lastPitch;
    public boolean isFirst = true;
    public int loops;
    public int currentLoop;
    public ArrayList<CamPoint> points = null;
    public static Minecraft mc = Minecraft.func_71410_x();

    public static void registerPath(String name, Path path) {
        paths.put(name, path);
    }

    public static Path getPathById(String lastPath) {
        return paths.get(lastPath);
    }

    public static void initPaths() {
        Path.registerPath("default", new DefaultPath(null, 0L, 0, null, null));
        Path.registerPath("outside", new OutsidePath(null, 0L, 0, null, null));
    }

    public Path(ArrayList<CamPoint> points, long duration, int loops, Movement movement, Object target) {
        this.duration = duration;
        this.movement = movement;
        if (points != null) {
            this.points = new ArrayList<CamPoint>(points);
            this.hideGui = Path.mc.field_71474_y.field_74319_N;
            this.lastPitch = points.get((int)0).rotationPitch;
            this.lastYaw = points.get((int)0).rotationYaw;
        }
        this.target = target;
        this.loops = loops;
        this.currentLoop = 0;
        if (this.loops != 0) {
            this.points.add(this.points.get(this.points.size() - 1).copy());
        }
    }

    public static Vec3d getVecOfTarget(Object target) {
        if (target instanceof Entity) {
            if (target instanceof EntityLivingBase) {
                return ((EntityLivingBase)target).func_174824_e(mc.func_184121_ak()).func_178788_d(new Vec3d(0.0, (double)((EntityLivingBase)target).func_70047_e(), 0.0));
            }
            return ((Entity)target).func_174824_e(mc.func_184121_ak());
        }
        if (target instanceof BlockPos) {
            return new Vec3d((double)((BlockPos)target).func_177958_n() + 0.5, (double)((BlockPos)target).func_177956_o() + 0.5, (double)((BlockPos)target).func_177952_p() + 0.5);
        }
        return null;
    }

    public abstract Path createPath(ArrayList<CamPoint> var1, long var2, int var4, Movement var5, Object var6);

    public CamPoint getCamPoint(CamPoint point1, CamPoint point2, double percent, double wholeProgress, float renderTickTime, boolean isFirstLoop, boolean isLastLoop) {
        CamPoint newPoint = this.movement.getPointInBetween(point1, point2, percent, wholeProgress, isFirstLoop, isLastLoop);
        if (this.target != null) {
            newPoint.rotationPitch = this.lastPitch;
            newPoint.rotationYaw = this.lastYaw;
            Vec3d pos = Path.getVecOfTarget(this.target);
            if (pos != null) {
                long timeSinceLastRenderFrame = System.nanoTime() - CamEventHandler.lastRenderTime;
                newPoint.faceEntity(pos, 1.0E-8f, 1.0E-8f, (double)timeSinceLastRenderFrame / 6.0E8 * CMDCam.cameraFollowSpeed);
            }
            this.lastPitch = newPoint.rotationPitch;
            this.lastYaw = newPoint.rotationYaw;
        }
        return newPoint;
    }

    public void onPathStart() {
    }

    public EntityLivingBase getCamera() {
        return Path.mc.field_71439_g;
    }

    public static CamPoint getPoint(Movement movement, ArrayList<CamPoint> points, double percent, int currentLoop, int loops) {
        double lengthOfPoint = 1 / (points.size() - 1);
        int currentPoint = Math.min((int)(percent / lengthOfPoint), points.size() - 2);
        CamPoint point1 = points.get(currentPoint);
        CamPoint point2 = points.get(currentPoint + 1);
        double percentOfPoint = percent % lengthOfPoint;
        return movement.getPointInBetween(point1, point2, percent, percent, currentLoop == 0, currentLoop == loops);
    }

    public void tick(float renderTickTime) {
        long time;
        if (this.isFirst) {
            this.onPathStart();
            this.isFirst = false;
        }
        if ((time = System.currentTimeMillis() - this.started) >= this.duration) {
            if (this.currentLoop < this.loops || this.loops < 0) {
                this.started = System.currentTimeMillis();
                ++this.currentLoop;
            } else {
                CMDCam.currentPath = null;
                this.onPathFinished();
            }
        } else {
            double percent;
            CamPoint point2;
            long durationOfPoint = this.duration / (long)(this.points.size() - 1);
            int currentPoint = Math.min((int)(time / durationOfPoint), this.points.size() - 2);
            CamPoint point1 = this.points.get(currentPoint);
            CamPoint newPoint = this.getCamPoint(point1, point2 = this.points.get(currentPoint + 1), percent = (double)(time % durationOfPoint) / (double)durationOfPoint, (double)time / (double)this.duration, renderTickTime, this.currentLoop == 0, this.currentLoop == this.loops);
            if (newPoint != null) {
                this.processPoint(newPoint);
            }
        }
    }

    public abstract String getDescription();

    public void processPoint(CamPoint point) {
        Path.mc.field_71474_y.field_74319_N = true;
        CMDCam.roll = (float)point.roll;
        Path.mc.field_71474_y.field_74334_X = (float)point.zoom;
    }

    public void onPathFinished() {
        Path.mc.field_71474_y.field_74319_N = this.hideGui;
        CMDCam.fov = CamEventHandler.defaultfov;
        Path.mc.field_71474_y.field_74334_X = CamEventHandler.defaultfov;
        CMDCam.roll = 0.0f;
    }
}

