/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.cmdcam.utils;

import com.creativemd.cmdcam.CMDCam;
import net.minecraft.client.Minecraft;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;

public class CamPoint {
    public static Minecraft mc = Minecraft.func_71410_x();
    public double x;
    public double y;
    public double z;
    public double rotationYaw;
    public double rotationPitch;
    public double roll;
    public double zoom;

    public CamPoint(double x, double y, double z, double rotationYaw, double rotationPitch, double roll, double zoom) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.rotationYaw = rotationYaw;
        this.rotationPitch = rotationPitch;
        this.roll = roll;
        this.zoom = zoom;
    }

    public CamPoint() {
        this.x = CamPoint.mc.field_71439_g.field_70165_t;
        this.y = CamPoint.mc.field_71439_g.field_70163_u;
        this.z = CamPoint.mc.field_71439_g.field_70161_v;
        this.rotationYaw = CamPoint.mc.field_71439_g.field_70759_as;
        this.rotationPitch = CamPoint.mc.field_71439_g.field_70125_A;
        this.roll = CMDCam.roll;
        this.zoom = CMDCam.fov;
    }

    public CamPoint getPointBetween(CamPoint point, double percent) {
        return new CamPoint(this.x + (point.x - this.x) * percent, this.y + (point.y - this.y) * percent, this.z + (point.z - this.z) * percent, this.rotationYaw + (point.rotationYaw - this.rotationYaw) * percent, this.rotationPitch + (point.rotationPitch - this.rotationPitch) * percent, this.roll + (point.roll - this.roll) * percent, this.zoom + (point.zoom - this.zoom) * percent);
    }

    public void faceEntity(Vec3d pos, float minYaw, float minPitch, double ticks) {
        double d0 = pos.field_72450_a - this.x;
        double d2 = pos.field_72449_c - this.z;
        double d1 = pos.field_72448_b - this.y;
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        double f2 = Math.atan2(d2, d0) * 180.0 / Math.PI - 90.0;
        double f3 = -(Math.atan2(d1, d3) * 180.0 / Math.PI);
        this.rotationPitch = this.updateRotation(this.rotationPitch, f3, minPitch, ticks);
        this.rotationYaw = this.updateRotation(this.rotationYaw, f2, minYaw, ticks);
    }

    private double updateRotation(double rotation, double intended, double min, double ticks) {
        double f3 = MathHelper.func_76138_g((double)(intended - rotation));
        f3 = f3 > 0.0 ? Math.min(Math.abs(f3 * ticks), f3) : Math.max(-Math.abs(f3 * ticks), f3);
        return rotation + f3;
    }

    public CamPoint copy() {
        return new CamPoint(this.x, this.y, this.z, this.rotationYaw, this.rotationPitch, this.roll, this.zoom);
    }

    public String toString() {
        return "x:" + this.x + ",y:" + this.y + ",z:" + this.z + ",yaw:" + this.rotationYaw + ",pitch:" + this.rotationPitch + ",roll:" + this.roll + ",zoom:" + this.zoom;
    }
}

