/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.cmdcam.client;

import com.creativemd.cmdcam.client.CMDCamClient;
import com.creativemd.cmdcam.client.CamEventHandlerClient;
import com.creativemd.cmdcam.client.PathParseException;
import com.creativemd.cmdcam.client.interpolation.CamInterpolation;
import com.creativemd.cmdcam.common.packet.GetPathPacket;
import com.creativemd.cmdcam.common.packet.SetPathPacket;
import com.creativemd.cmdcam.common.utils.CamPath;
import com.creativemd.cmdcam.common.utils.CamPoint;
import com.creativemd.cmdcam.common.utils.CamTarget;
import com.creativemd.cmdcam.server.CamCommandServer;
import com.creativemd.creativecore.common.packet.CreativeCorePacket;
import com.creativemd.creativecore.common.packet.PacketHandler;
import com.mojang.realmsclient.gui.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;

public class CamCommandClient
extends CommandBase {
    public static Minecraft mc = Minecraft.func_71410_x();

    public int func_82362_a() {
        return 0;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length == 0) {
            sender.func_145747_a((ITextComponent)new TextComponentString("" + ChatFormatting.BOLD + ChatFormatting.YELLOW + "/cam add [number] " + ChatFormatting.RED + "register a point at the current position"));
            sender.func_145747_a((ITextComponent)new TextComponentString("" + ChatFormatting.BOLD + ChatFormatting.YELLOW + "/cam clear " + ChatFormatting.RED + "delete all registered points"));
            sender.func_145747_a((ITextComponent)new TextComponentString("" + ChatFormatting.BOLD + ChatFormatting.YELLOW + "/cam start [time|ms|s|m|h|d] [loops (-1 -> endless)] " + ChatFormatting.RED + "starts the animation"));
            sender.func_145747_a((ITextComponent)new TextComponentString("" + ChatFormatting.BOLD + ChatFormatting.YELLOW + "/cam stop " + ChatFormatting.RED + "stops the animation"));
            sender.func_145747_a((ITextComponent)new TextComponentString("" + ChatFormatting.BOLD + ChatFormatting.YELLOW + "/cam goto <index> " + ChatFormatting.RED + "tp to the given point"));
            sender.func_145747_a((ITextComponent)new TextComponentString("" + ChatFormatting.BOLD + ChatFormatting.YELLOW + "/cam set <index> " + ChatFormatting.RED + "updates point to current location"));
            sender.func_145747_a((ITextComponent)new TextComponentString("" + ChatFormatting.BOLD + ChatFormatting.YELLOW + "/cam remove <index> " + ChatFormatting.RED + "removes the given point"));
            sender.func_145747_a((ITextComponent)new TextComponentString("" + ChatFormatting.BOLD + ChatFormatting.YELLOW + "/cam target <none:self> " + ChatFormatting.RED + "set the camera target"));
            sender.func_145747_a((ITextComponent)new TextComponentString("" + ChatFormatting.BOLD + ChatFormatting.YELLOW + "/cam mode <default:outside> " + ChatFormatting.RED + "set current mode"));
            sender.func_145747_a((ITextComponent)new TextComponentString("" + ChatFormatting.BOLD + ChatFormatting.YELLOW + "/cam interpolation <" + String.join((CharSequence)":", CamInterpolation.getMovementNames()) + "> " + ChatFormatting.RED + "set the camera interpolation"));
            sender.func_145747_a((ITextComponent)new TextComponentString("" + ChatFormatting.BOLD + ChatFormatting.YELLOW + "/cam follow-speed <number> " + ChatFormatting.RED + "default is 1.0"));
            sender.func_145747_a((ITextComponent)new TextComponentString("" + ChatFormatting.BOLD + ChatFormatting.YELLOW + "/cam show <all:" + String.join((CharSequence)":", CamInterpolation.getMovementNames()) + "> " + ChatFormatting.RED + "shows the path using the given interpolation"));
            sender.func_145747_a((ITextComponent)new TextComponentString("" + ChatFormatting.BOLD + ChatFormatting.YELLOW + "/cam hide <all:" + String.join((CharSequence)":", CamInterpolation.getMovementNames()) + "> " + ChatFormatting.RED + "hides the path using the given interpolation"));
            sender.func_145747_a((ITextComponent)new TextComponentString("" + ChatFormatting.BOLD + ChatFormatting.YELLOW + "/cam save <name> " + ChatFormatting.RED + "saves the current path (including settings) with the given name"));
            sender.func_145747_a((ITextComponent)new TextComponentString("" + ChatFormatting.BOLD + ChatFormatting.YELLOW + "/cam load <name> " + ChatFormatting.RED + "tries to load the saved path with the given name"));
            sender.func_145747_a((ITextComponent)new TextComponentString("" + ChatFormatting.BOLD + ChatFormatting.YELLOW + "/cam list " + ChatFormatting.RED + "lists all saved paths"));
        } else {
            String subCommand;
            block94: {
                CamInterpolation move;
                String target;
                block93: {
                    Integer index;
                    block92: {
                        block91: {
                            block90: {
                                subCommand = args[0];
                                if (subCommand.equals("clear")) {
                                    sender.func_145747_a((ITextComponent)new TextComponentString("Cleared all registered points!"));
                                    CMDCamClient.points.clear();
                                }
                                if (subCommand.equals("add")) {
                                    if (args.length == 1) {
                                        CMDCamClient.points.add(new CamPoint());
                                        sender.func_145747_a((ITextComponent)new TextComponentString("Registered " + CMDCamClient.points.size() + ". Point!"));
                                    } else if (args.length == 2) {
                                        try {
                                            index = Integer.parseInt(args[1]) - 1;
                                            if (index >= 0 && index < CMDCamClient.points.size()) {
                                                CMDCamClient.points.add(index, new CamPoint());
                                                sender.func_145747_a((ITextComponent)new TextComponentString("Inserted " + index + ". Point!"));
                                                break block90;
                                            }
                                            sender.func_145747_a((ITextComponent)new TextComponentString("The given index '" + args[1] + "' is too high/low!"));
                                        }
                                        catch (Exception e) {
                                            sender.func_145747_a((ITextComponent)new TextComponentString("Invalid index '" + args[1] + "'!"));
                                        }
                                    } else {
                                        sender.func_145747_a((ITextComponent)new TextComponentString("" + ChatFormatting.BOLD + ChatFormatting.YELLOW + "/cam add [number] " + ChatFormatting.RED + "register a point at the current position."));
                                    }
                                }
                            }
                            if (subCommand.equals("start")) {
                                if (args.length >= 2) {
                                    long duration = CamCommandServer.StringToDuration(args[1]);
                                    if (duration <= 0L) {
                                        sender.func_145747_a((ITextComponent)new TextComponentString("Invalid time '" + args[1] + "'!"));
                                        return;
                                    }
                                    CMDCamClient.lastDuration = duration;
                                    if (args.length >= 3) {
                                        CMDCamClient.lastLoop = Integer.parseInt(args[2]);
                                    }
                                }
                                try {
                                    CMDCamClient.startPath(CMDCamClient.createPathFromCurrentConfiguration());
                                }
                                catch (PathParseException e) {
                                    sender.func_145747_a((ITextComponent)new TextComponentString(e.getMessage()));
                                }
                            }
                            if (subCommand.equals("stop")) {
                                CMDCamClient.stopPath();
                            }
                            if (subCommand.equals("remove")) {
                                if (args.length >= 2) {
                                    try {
                                        index = Integer.parseInt(args[1]) - 1;
                                        if (index >= 0 && index < CMDCamClient.points.size()) {
                                            CMDCamClient.points.remove(index);
                                            sender.func_145747_a((ITextComponent)new TextComponentString("Removed " + (index + 1) + ". point!"));
                                            break block91;
                                        }
                                        sender.func_145747_a((ITextComponent)new TextComponentString("The given index '" + args[1] + "' is too high/low!"));
                                    }
                                    catch (Exception e) {
                                        sender.func_145747_a((ITextComponent)new TextComponentString("Invalid index '" + args[1] + "'!"));
                                    }
                                } else {
                                    sender.func_145747_a((ITextComponent)new TextComponentString("" + ChatFormatting.BOLD + ChatFormatting.YELLOW + "/cam remove <index> " + ChatFormatting.RED + "removes the given point"));
                                }
                            }
                        }
                        if (subCommand.equals("set")) {
                            if (args.length >= 2) {
                                try {
                                    index = Integer.parseInt(args[1]) - 1;
                                    if (index >= 0 && index < CMDCamClient.points.size()) {
                                        CMDCamClient.points.set(index, new CamPoint());
                                        sender.func_145747_a((ITextComponent)new TextComponentString("Updated " + (index + 1) + ". point!"));
                                        break block92;
                                    }
                                    sender.func_145747_a((ITextComponent)new TextComponentString("The given index '" + args[1] + "' is too high/low!"));
                                }
                                catch (Exception e) {
                                    sender.func_145747_a((ITextComponent)new TextComponentString("Invalid index '" + args[1] + "'!"));
                                }
                            } else {
                                sender.func_145747_a((ITextComponent)new TextComponentString("" + ChatFormatting.BOLD + ChatFormatting.YELLOW + "/cam set <index> " + ChatFormatting.RED + "updates the giveng point to the current location"));
                            }
                        }
                    }
                    if (subCommand.equals("goto")) {
                        if (args.length >= 2) {
                            try {
                                index = Integer.parseInt(args[1]) - 1;
                                if (index >= 0 && index < CMDCamClient.points.size()) {
                                    CamPoint point = CMDCamClient.points.get(index);
                                    CamCommandClient.mc.field_71439_g.field_71075_bZ.field_75100_b = true;
                                    CamEventHandlerClient.roll = (float)point.roll;
                                    CamCommandClient.mc.field_71474_y.field_74334_X = (float)point.zoom;
                                    CamCommandClient.mc.field_71439_g.func_70080_a(point.x, point.y, point.z, (float)point.rotationYaw, (float)point.rotationPitch);
                                    CamCommandClient.mc.field_71439_g.func_70012_b(point.x, point.y, point.z, (float)point.rotationYaw, (float)point.rotationPitch);
                                    break block93;
                                }
                                sender.func_145747_a((ITextComponent)new TextComponentString("The given index '" + args[1] + "' is too high/low!"));
                            }
                            catch (Exception e) {
                                sender.func_145747_a((ITextComponent)new TextComponentString("Invalid index '" + args[1] + "'!"));
                            }
                        } else {
                            sender.func_145747_a((ITextComponent)new TextComponentString("Missing point!"));
                            sender.func_145747_a((ITextComponent)new TextComponentString("" + ChatFormatting.BOLD + ChatFormatting.YELLOW + "/cam goto <index> " + ChatFormatting.RED + "tp to the given point"));
                        }
                    }
                }
                if (subCommand.equals("mode")) {
                    if (args.length >= 2) {
                        if (args[1].equals("default") || args[1].equals("outside")) {
                            CMDCamClient.lastMode = args[1];
                            sender.func_145747_a((ITextComponent)new TextComponentString("Changed to " + args[1] + " path!"));
                        } else {
                            sender.func_145747_a((ITextComponent)new TextComponentString("Path mode '" + args[1] + "' does not exit!"));
                        }
                    } else {
                        sender.func_145747_a((ITextComponent)new TextComponentString("" + ChatFormatting.BOLD + ChatFormatting.YELLOW + "/cam mode <default:outside> " + ChatFormatting.RED + "set current mode"));
                    }
                }
                if (subCommand.equals("target")) {
                    if (args.length == 2) {
                        target = args[1];
                        if (target.equals("self")) {
                            CMDCamClient.target = new CamTarget.SelfTarget();
                            sender.func_145747_a((ITextComponent)new TextComponentString("The camera will point towards you!"));
                        } else if (target.equals("none")) {
                            CMDCamClient.target = null;
                            sender.func_145747_a((ITextComponent)new TextComponentString("Removed target!"));
                        } else {
                            sender.func_145747_a((ITextComponent)new TextComponentString("Target '" + target + "' not found!"));
                        }
                    } else {
                        CamEventHandlerClient.selectEntityMode = true;
                        sender.func_145747_a((ITextComponent)new TextComponentString("Please select a target either an entity or a block!"));
                    }
                }
                if (subCommand.equals("interpolation")) {
                    if (args.length == 2) {
                        target = args[1];
                        move = CamInterpolation.getInterpolation(target);
                        if (move != null) {
                            CMDCamClient.lastInterpolation = target;
                            sender.func_145747_a((ITextComponent)new TextComponentString("Interpolation is set to '" + target + "'!"));
                        } else {
                            sender.func_145747_a((ITextComponent)new TextComponentString("Interpolation '" + target + "' not found!"));
                        }
                    } else {
                        sender.func_145747_a((ITextComponent)new TextComponentString("" + ChatFormatting.BOLD + ChatFormatting.YELLOW + "/cam interpolation <" + String.join((CharSequence)":", CamInterpolation.getMovementNames()) + "> " + ChatFormatting.RED + "set the camera interpolation"));
                    }
                }
                if (subCommand.equals("follow-speed")) {
                    if (args.length == 2) {
                        try {
                            double followspeed;
                            CMDCamClient.cameraFollowSpeed = followspeed = Double.parseDouble(args[1]);
                            sender.func_145747_a((ITextComponent)new TextComponentString("Camera follow speed is set to  '" + followspeed + "'. Default is 1.0!"));
                        }
                        catch (NumberFormatException e) {
                            sender.func_145747_a((ITextComponent)new TextComponentString("'" + args[1] + "' is an invalid number!"));
                        }
                    } else {
                        sender.func_145747_a((ITextComponent)new TextComponentString("" + ChatFormatting.BOLD + ChatFormatting.YELLOW + "/cam follow-speed <number> " + ChatFormatting.RED + "default is 1.0"));
                    }
                }
                if (subCommand.equals("show")) {
                    if (args.length == 2) {
                        String target2 = args[1];
                        move = CamInterpolation.getInterpolation(target2);
                        if (move != null) {
                            move.isRenderingEnabled = true;
                            sender.func_145747_a((ITextComponent)new TextComponentString("Showing '" + target2 + "' interpolation path!"));
                        } else if (target2.equals("all")) {
                            for (CamInterpolation movement : CamInterpolation.interpolationTypes.values()) {
                                movement.isRenderingEnabled = true;
                            }
                            sender.func_145747_a((ITextComponent)new TextComponentString("Showing all interpolation paths!"));
                        } else {
                            sender.func_145747_a((ITextComponent)new TextComponentString("Interpolation '" + target2 + "' not found!"));
                        }
                    } else {
                        sender.func_145747_a((ITextComponent)new TextComponentString("" + ChatFormatting.BOLD + ChatFormatting.YELLOW + "/cam show <all:" + String.join((CharSequence)":", CamInterpolation.getMovementNames()) + "> " + ChatFormatting.RED + "shows the path using the given interpolation"));
                    }
                }
                if (subCommand.equals("hide")) {
                    if (args.length == 2) {
                        String target3 = args[1];
                        move = CamInterpolation.getInterpolation(target3);
                        if (move != null) {
                            move.isRenderingEnabled = false;
                            sender.func_145747_a((ITextComponent)new TextComponentString("Hiding '" + target3 + "' interpolation path!"));
                        } else if (target3.equals("all")) {
                            for (CamInterpolation movement : CamInterpolation.interpolationTypes.values()) {
                                movement.isRenderingEnabled = false;
                            }
                            sender.func_145747_a((ITextComponent)new TextComponentString("Hiding all interpolation paths!"));
                        } else {
                            sender.func_145747_a((ITextComponent)new TextComponentString("Interpolation '" + target3 + "' not found!"));
                        }
                    } else {
                        sender.func_145747_a((ITextComponent)new TextComponentString("" + ChatFormatting.BOLD + ChatFormatting.YELLOW + "/cam hide <all:" + String.join((CharSequence)":", CamInterpolation.getMovementNames()) + "> " + ChatFormatting.RED + "hides the path using the given interpolation"));
                    }
                }
                if (subCommand.equals("save")) {
                    if (args.length == 2) {
                        try {
                            CamPath path = CMDCamClient.createPathFromCurrentConfiguration();
                            if (CMDCamClient.isInstalledOnSever) {
                                PacketHandler.sendPacketToServer((CreativeCorePacket)new SetPathPacket(args[1], path));
                                break block94;
                            }
                            CMDCamClient.savedPaths.put(args[1], path);
                            sender.func_145747_a((ITextComponent)new TextComponentString("Saved path '" + args[1] + "' successfully!"));
                        }
                        catch (PathParseException e) {
                            sender.func_145747_a((ITextComponent)new TextComponentString(e.getMessage()));
                        }
                    } else {
                        sender.func_145747_a((ITextComponent)new TextComponentString("" + ChatFormatting.BOLD + ChatFormatting.YELLOW + "/cam save <name> " + ChatFormatting.RED + "saves the current path (including settings) with the given name"));
                    }
                }
            }
            if (subCommand.equals("load")) {
                if (args.length == 2) {
                    if (CMDCamClient.isInstalledOnSever) {
                        PacketHandler.sendPacketToServer((CreativeCorePacket)new GetPathPacket(args[1]));
                    } else {
                        CamPath path = CMDCamClient.savedPaths.get(args[1]);
                        if (path != null) {
                            path.overwriteClientConfig();
                            sender.func_145747_a((ITextComponent)new TextComponentString("Loaded path '" + args[1] + "' successfully!"));
                        } else {
                            sender.func_145747_a((ITextComponent)new TextComponentString("Could not find path '" + args[1] + "'!"));
                        }
                    }
                } else {
                    sender.func_145747_a((ITextComponent)new TextComponentString("" + ChatFormatting.BOLD + ChatFormatting.YELLOW + "/cam load <name> " + ChatFormatting.RED + "tries to load the saved path with the given name"));
                }
            }
            if (subCommand.equals("list")) {
                if (CMDCamClient.isInstalledOnSever) {
                    sender.func_145747_a((ITextComponent)new TextComponentString("Use /cam-server list instead!"));
                    return;
                }
                String output = "There are " + CMDCamClient.savedPaths.size() + " path(s) in total. ";
                for (String key : CMDCamClient.savedPaths.keySet()) {
                    output = output + key + ", ";
                }
                sender.func_145747_a((ITextComponent)new TextComponentString(output));
            }
        }
    }

    public String func_71517_b() {
        return "cam";
    }

    public String func_71518_a(ICommandSender sender) {
        return "used to control the camera";
    }
}

