/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.cmdcam.client.interpolation;

import com.creativemd.cmdcam.client.PathParseException;
import com.creativemd.cmdcam.client.interpolation.CircularMovement;
import com.creativemd.cmdcam.client.interpolation.CubicMovement;
import com.creativemd.cmdcam.client.interpolation.HermiteMovement;
import com.creativemd.cmdcam.client.interpolation.LinearMovement;
import com.creativemd.cmdcam.client.interpolation.SmoothMovement;
import com.creativemd.cmdcam.common.utils.CamPoint;
import com.creativemd.cmdcam.common.utils.CamTarget;
import com.creativemd.creativecore.common.utils.math.vec.Vec3;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public abstract class CamInterpolation {
    public static HashMap<String, CamInterpolation> interpolationTypes = new HashMap();
    public static LinearMovement linear = new LinearMovement();
    public static SmoothMovement cosine = new SmoothMovement();
    public static CubicMovement cubic = new CubicMovement();
    public static HermiteMovement hermite = new HermiteMovement();
    public static CircularMovement circular = new CircularMovement();
    public boolean isRenderingEnabled = false;

    public static CamInterpolation getInterpolationOrDefault(String interpolation) {
        return interpolationTypes.getOrDefault(interpolation, hermite);
    }

    public static CamInterpolation getInterpolation(String interpolation) {
        return interpolationTypes.get(interpolation);
    }

    public static void registerInterpolation(String name, CamInterpolation interpolation) {
        interpolationTypes.put(name, interpolation);
    }

    public static String[] getMovementNames() {
        String[] names = new String[interpolationTypes.size()];
        int i = 0;
        Iterator<String> iterator = interpolationTypes.keySet().iterator();
        while (iterator.hasNext()) {
            String name;
            names[i] = name = iterator.next();
            ++i;
        }
        return names;
    }

    public abstract Vec3 getColor();

    public abstract void initMovement(List<CamPoint> var1, int var2, CamTarget var3) throws PathParseException;

    public abstract CamPoint getPointInBetween(CamPoint var1, CamPoint var2, double var3, double var5, boolean var7, boolean var8);

    static {
        CamInterpolation.registerInterpolation("linear", linear);
        CamInterpolation.registerInterpolation("cubic", cubic);
        CamInterpolation.registerInterpolation("hermite", hermite);
        CamInterpolation.registerInterpolation("cosine", cosine);
        CamInterpolation.registerInterpolation("circular", circular);
    }
}

