/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.cmdcam.client.interpolation;

import com.creativemd.cmdcam.client.PathParseException;
import com.creativemd.cmdcam.client.interpolation.CamInterpolation;
import com.creativemd.cmdcam.common.utils.CamPoint;
import com.creativemd.cmdcam.common.utils.CamTarget;
import com.creativemd.creativecore.common.utils.math.interpolation.CosineInterpolation;
import com.creativemd.creativecore.common.utils.math.vec.Vec;
import com.creativemd.creativecore.common.utils.math.vec.Vec1;
import com.creativemd.creativecore.common.utils.math.vec.Vec3;
import java.util.List;

public class SmoothMovement
extends CamInterpolation {
    public CosineInterpolation<Vec1> rollSpline;
    public CosineInterpolation<Vec1> zoomSpline;
    public CosineInterpolation<Vec1> pitchSpline;
    public CosineInterpolation<Vec1> yawSpline;
    public CosineInterpolation<Vec3> positionSpline;
    public double sizeOfIteration;

    @Override
    public void initMovement(List<CamPoint> points, int loops, CamTarget target) throws PathParseException {
        if (points.size() == 1) {
            throw new PathParseException("At least two points are required");
        }
        int iterations = loops == 0 ? 1 : (loops == 1 ? 2 : 3);
        this.sizeOfIteration = 1.0 / (double)iterations;
        int size = points.size() * iterations;
        if (iterations > 1) {
            ++size;
        }
        Vec1[] rollPoints = new Vec1[size];
        Vec1[] zoomPoints = new Vec1[size];
        Vec1[] yawPoints = new Vec1[size];
        Vec1[] pitchPoints = new Vec1[size];
        Vec3[] positionPoints = new Vec3[size];
        for (int j = 0; j < iterations; ++j) {
            for (int i = 0; i < points.size(); ++i) {
                rollPoints[i + j * points.size()] = new Vec1(points.get((int)i).roll);
                zoomPoints[i + j * points.size()] = new Vec1(points.get((int)i).zoom);
                yawPoints[i + j * points.size()] = new Vec1(points.get((int)i).rotationYaw);
                pitchPoints[i + j * points.size()] = new Vec1(points.get((int)i).rotationPitch);
                positionPoints[i + j * points.size()] = new Vec3(points.get((int)i).x, points.get((int)i).y, points.get((int)i).z);
            }
        }
        if (iterations > 1) {
            rollPoints[points.size() * iterations] = new Vec1(points.get((int)0).roll);
            zoomPoints[points.size() * iterations] = new Vec1(points.get((int)0).zoom);
            yawPoints[points.size() * iterations] = new Vec1(points.get((int)0).rotationYaw);
            pitchPoints[points.size() * iterations] = new Vec1(points.get((int)0).rotationPitch);
            positionPoints[points.size() * iterations] = new Vec3(points.get((int)0).x, points.get((int)0).y, points.get((int)0).z);
        }
        this.rollSpline = new CosineInterpolation((Vec[])rollPoints);
        this.zoomSpline = new CosineInterpolation((Vec[])zoomPoints);
        this.pitchSpline = new CosineInterpolation((Vec[])pitchPoints);
        this.yawSpline = new CosineInterpolation((Vec[])yawPoints);
        this.positionSpline = new CosineInterpolation((Vec[])positionPoints);
    }

    @Override
    public CamPoint getPointInBetween(CamPoint point1, CamPoint point2, double percent, double wholeProgress, boolean isFirstLoop, boolean isLastLoop) {
        CamPoint point = point1.getPointBetween(point2, percent);
        int iteration = isFirstLoop ? 0 : (isLastLoop && this.sizeOfIteration < 0.5 ? 2 : 1);
        double additionalProgress = (double)iteration * this.sizeOfIteration;
        wholeProgress = additionalProgress + wholeProgress * this.sizeOfIteration;
        if (this.rollSpline != null) {
            point.roll = ((Vec1)this.rollSpline.valueAt((double)wholeProgress)).x;
        }
        if (this.zoomSpline != null) {
            point.zoom = ((Vec1)this.zoomSpline.valueAt((double)wholeProgress)).x;
        }
        if (this.yawSpline != null) {
            point.rotationYaw = ((Vec1)this.yawSpline.valueAt((double)wholeProgress)).x;
        }
        if (this.pitchSpline != null) {
            point.rotationPitch = ((Vec1)this.pitchSpline.valueAt((double)wholeProgress)).x;
        }
        if (this.positionSpline != null) {
            Vec3 position = (Vec3)this.positionSpline.valueAt(wholeProgress);
            point.x = position.x;
            point.y = position.y;
            point.z = position.z;
        }
        return point;
    }

    @Override
    public Vec3 getColor() {
        return new Vec3(0.0, 1.0, 0.0);
    }
}

