/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.cmdcam.client.mode;

import com.creativemd.cmdcam.client.CamEventHandlerClient;
import com.creativemd.cmdcam.client.interpolation.CamInterpolation;
import com.creativemd.cmdcam.client.mode.DefaultMode;
import com.creativemd.cmdcam.client.mode.OutsideMode;
import com.creativemd.cmdcam.common.utils.CamPath;
import com.creativemd.cmdcam.common.utils.CamPoint;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public abstract class CamMode {
    protected static Minecraft mc = Minecraft.func_71410_x();
    public static HashMap<String, CamMode> modes = new HashMap();
    public static DefaultMode defaultMode = new DefaultMode(null);
    public final CamPath path;
    public double lastYaw;
    public double lastPitch;

    public static void registerPath(String id, CamMode path) {
        modes.put(id, path);
    }

    public static CamMode getMode(String id) {
        return modes.getOrDefault(id, defaultMode);
    }

    public CamMode(CamPath path) {
        this.path = path;
        if (path != null) {
            this.lastPitch = path.tempPoints.get((int)0).rotationPitch;
            this.lastYaw = path.tempPoints.get((int)0).rotationYaw;
        }
    }

    public abstract CamMode createMode(CamPath var1);

    public CamPoint getCamPoint(CamPoint point1, CamPoint point2, double percent, double wholeProgress, float renderTickTime, boolean isFirstLoop, boolean isLastLoop) {
        CamPoint newPoint = this.path.cachedInterpolation.getPointInBetween(point1, point2, percent, wholeProgress, isFirstLoop, isLastLoop);
        if (this.path.target != null) {
            newPoint.rotationPitch = this.lastPitch;
            newPoint.rotationYaw = this.lastYaw;
            Vec3d pos = this.path.target.getTargetVec((World)CamMode.mc.field_71441_e, mc.func_184121_ak());
            if (pos != null) {
                long timeSinceLastRenderFrame = System.nanoTime() - CamEventHandlerClient.lastRenderTime;
                newPoint.faceEntity(pos, 1.0E-8f, 1.0E-8f, (double)timeSinceLastRenderFrame / 6.0E8 * this.path.cameraFollowSpeed);
            }
            this.lastPitch = newPoint.rotationPitch;
            this.lastYaw = newPoint.rotationYaw;
        }
        return newPoint;
    }

    public void onPathStart() {
    }

    public void onPathFinish() {
        CamMode.mc.field_71474_y.field_74334_X = CamEventHandlerClient.defaultfov;
        CamEventHandlerClient.roll = 0.0f;
    }

    public EntityLivingBase getCamera() {
        return CamMode.mc.field_71439_g;
    }

    public abstract String getDescription();

    public void processPoint(CamPoint point) {
        CamEventHandlerClient.roll = (float)point.roll;
        CamMode.mc.field_71474_y.field_74334_X = (float)point.zoom;
    }

    public static CamPoint getPoint(CamInterpolation movement, ArrayList<CamPoint> points, double percent, int currentLoop, int loops) {
        double lengthOfPoint = 1 / (points.size() - 1);
        int currentPoint = Math.min((int)(percent / lengthOfPoint), points.size() - 2);
        CamPoint point1 = points.get(currentPoint);
        CamPoint point2 = points.get(currentPoint + 1);
        double percentOfPoint = percent % lengthOfPoint;
        return movement.getPointInBetween(point1, point2, percent, percent, currentLoop == 0, currentLoop == loops);
    }

    static {
        CamMode.registerPath("default", defaultMode);
        CamMode.registerPath("outside", new OutsideMode(null));
    }
}

