/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.cmdcam.common.packet;

import com.creativemd.cmdcam.common.utils.CamPath;
import com.creativemd.cmdcam.server.CMDCamServer;
import com.creativemd.creativecore.common.packet.CreativeCorePacket;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;

public class SetPathPacket
extends CreativeCorePacket {
    public String id;
    public CamPath path;

    public SetPathPacket() {
    }

    public SetPathPacket(String id, CamPath path) {
        this.id = id;
        this.path = path;
    }

    public void writeBytes(ByteBuf buf) {
        SetPathPacket.writeString((ByteBuf)buf, (String)this.id);
        SetPathPacket.writeNBT((ByteBuf)buf, (NBTTagCompound)this.path.writeToNBT(new NBTTagCompound()));
    }

    public void readBytes(ByteBuf buf) {
        this.id = SetPathPacket.readString((ByteBuf)buf);
        this.path = new CamPath(SetPathPacket.readNBT((ByteBuf)buf));
    }

    public void executeClient(EntityPlayer player) {
        this.path.overwriteClientConfig();
        player.func_145747_a((ITextComponent)new TextComponentString("Loaded path '" + this.id + "' successfully!"));
    }

    public void executeServer(EntityPlayer player) {
        if (player.func_70003_b(4, "cam-server")) {
            CMDCamServer.setPath(player.field_70170_p, this.id, this.path);
            player.func_145747_a((ITextComponent)new TextComponentString("Saved path '" + this.id + "' successfully!"));
        } else {
            player.func_145747_a((ITextComponent)new TextComponentString("You do not have the permission to edit the path list!"));
        }
    }
}

