/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.cmdcam.common.utils;

import com.creativemd.cmdcam.client.CMDCamClient;
import com.creativemd.cmdcam.client.PathParseException;
import com.creativemd.cmdcam.client.interpolation.CamInterpolation;
import com.creativemd.cmdcam.client.mode.CamMode;
import com.creativemd.cmdcam.common.utils.CamPoint;
import com.creativemd.cmdcam.common.utils.CamTarget;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CamPath {
    public int loop;
    public long duration;
    public String mode;
    public String interpolation;
    public CamTarget target;
    public List<CamPoint> points;
    public double cameraFollowSpeed;
    public boolean serverPath = false;
    @SideOnly(value=Side.CLIENT)
    private boolean hideGui;
    @SideOnly(value=Side.CLIENT)
    public CamInterpolation cachedInterpolation;
    @SideOnly(value=Side.CLIENT)
    public CamMode cachedMode;
    public long timeStarted = System.currentTimeMillis();
    public int currentLoop;
    private boolean finished;
    private boolean running;
    public List<CamPoint> tempPoints;

    public CamPath(NBTTagCompound nbt) {
        this.loop = nbt.func_74762_e("loop");
        this.duration = nbt.func_74763_f("duration");
        this.mode = nbt.func_74779_i("mode");
        this.interpolation = nbt.func_74779_i("interpolation");
        if (nbt.func_74764_b("target")) {
            this.target = CamTarget.readFromNBT(nbt.func_74775_l("target"));
        }
        NBTTagList list = nbt.func_150295_c("points", 10);
        this.points = new ArrayList<CamPoint>();
        for (NBTBase point : list) {
            this.points.add(new CamPoint((NBTTagCompound)point));
        }
        this.cameraFollowSpeed = nbt.func_74769_h("cameraFollowSpeed");
    }

    public CamPath(int loop, long duration, String mode, String interpolation, CamTarget target, List<CamPoint> points, double cameraFollowSpeed) {
        this.loop = loop;
        this.duration = duration;
        this.mode = mode;
        this.interpolation = interpolation;
        this.target = target;
        this.points = points;
        this.cameraFollowSpeed = cameraFollowSpeed;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("loop", this.loop);
        nbt.func_74772_a("duration", this.duration);
        nbt.func_74778_a("mode", this.mode);
        nbt.func_74778_a("interpolation", this.interpolation);
        if (this.target != null) {
            nbt.func_74782_a("target", (NBTBase)this.target.writeToNBT(new NBTTagCompound()));
        }
        NBTTagList list = new NBTTagList();
        for (CamPoint point : this.points) {
            list.func_74742_a((NBTBase)point.writeToNBT(new NBTTagCompound()));
        }
        nbt.func_74782_a("points", (NBTBase)list);
        nbt.func_74780_a("cameraFollowSpeed", this.cameraFollowSpeed);
        return nbt;
    }

    @SideOnly(value=Side.CLIENT)
    public void overwriteClientConfig() {
        CMDCamClient.lastLoop = this.loop;
        CMDCamClient.lastDuration = this.duration;
        CMDCamClient.lastMode = this.mode;
        CMDCamClient.lastInterpolation = this.interpolation;
        CMDCamClient.target = this.target;
        CMDCamClient.points = new ArrayList<CamPoint>(this.points);
        CMDCamClient.cameraFollowSpeed = this.cameraFollowSpeed;
    }

    public void start(World world) throws PathParseException {
        this.finished = false;
        this.running = true;
        this.timeStarted = System.currentTimeMillis();
        this.currentLoop = 0;
        this.tempPoints = new ArrayList<CamPoint>(this.points);
        if (this.loop != 0) {
            this.tempPoints.add(this.tempPoints.get(this.tempPoints.size() - 1).copy());
        }
        if (world.field_72995_K) {
            CamMode parser = CamMode.getMode(this.mode);
            this.cachedMode = parser.createMode(this);
            this.cachedMode.onPathStart();
            this.cachedInterpolation = CamInterpolation.getInterpolationOrDefault(this.interpolation);
            this.cachedInterpolation.initMovement(this.tempPoints, this.loop, this.target);
            this.hideGui = Minecraft.func_71410_x().field_71474_y.field_74319_N;
        }
    }

    public void finish(World world) {
        this.finished = true;
        this.running = false;
        if (world.field_72995_K) {
            this.cachedMode.onPathFinish();
            this.tempPoints = null;
            this.cachedMode = null;
            this.cachedInterpolation = null;
            Minecraft.func_71410_x().field_71474_y.field_74319_N = this.hideGui;
        }
    }

    public void tick(World world, float renderTickTime) {
        long time = System.currentTimeMillis() - this.timeStarted;
        if (time >= this.duration) {
            if (this.currentLoop < this.loop || this.loop < 0) {
                this.timeStarted = System.currentTimeMillis();
                ++this.currentLoop;
            } else {
                this.finish(world);
            }
        } else {
            double percent;
            CamPoint point2;
            long durationOfPoint;
            int currentPoint;
            CamPoint point1;
            CamPoint newPoint;
            if (world.field_72995_K) {
                Minecraft.func_71410_x().field_71474_y.field_74319_N = true;
            }
            if ((newPoint = this.cachedMode.getCamPoint(point1 = this.tempPoints.get(currentPoint = Math.min((int)(time / (durationOfPoint = this.duration / (long)(this.tempPoints.size() - 1))), this.tempPoints.size() - 2)), point2 = this.tempPoints.get(currentPoint + 1), percent = (double)(time % durationOfPoint) / (double)durationOfPoint, (double)time / (double)this.duration, renderTickTime, this.currentLoop == 0, this.currentLoop == this.loop)) != null) {
                this.cachedMode.processPoint(newPoint);
            }
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean hasFinished() {
        return this.finished;
    }

    public CamPath copy() {
        CamPath path = new CamPath(this.currentLoop, this.duration, this.mode, this.interpolation, this.target, new ArrayList<CamPoint>(this.points), this.cameraFollowSpeed);
        path.serverPath = this.serverPath;
        return path;
    }
}

