/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.cmdcam.common.utils;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public abstract class CamTarget {
    private static HashMap<String, Class<? extends CamTarget>> targetTypes = new HashMap();
    private static HashMap<Class<? extends CamTarget>, String> targetTypesInverted = new HashMap();

    public static void registerTargetType(Class<? extends CamTarget> targetClass, String id) {
        targetTypes.put(id, targetClass);
        targetTypesInverted.put(targetClass, id);
    }

    public static Class<? extends CamTarget> getClassByID(String id) {
        return targetTypes.get(id);
    }

    public static CamTarget readFromNBT(NBTTagCompound nbt) {
        Class<? extends CamTarget> targetClass = CamTarget.getClassByID(nbt.func_74779_i("id"));
        if (targetClass != null) {
            try {
                return targetClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                System.out.println("Invalid target class " + nbt.func_74779_i("id") + "," + targetClass.getName());
            }
        }
        return null;
    }

    public abstract Vec3d getTargetVec(World var1, float var2);

    protected abstract void write(NBTTagCompound var1);

    protected abstract void read(NBTTagCompound var1);

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt.func_74778_a("id", targetTypesInverted.get(this.getClass()));
        this.write(nbt);
        return nbt;
    }

    static {
        CamTarget.registerTargetType(BlockTarget.class, "block");
        CamTarget.registerTargetType(EntityTarget.class, "entity");
        CamTarget.registerTargetType(SelfTarget.class, "self");
    }

    public static class SelfTarget
    extends CamTarget {
        @Override
        protected void write(NBTTagCompound nbt) {
        }

        @Override
        protected void read(NBTTagCompound nbt) {
        }

        @Override
        public Vec3d getTargetVec(World world, float partialTicks) {
            EntityPlayerSP cachedEntity = Minecraft.func_71410_x().field_71439_g;
            if (cachedEntity instanceof EntityLivingBase) {
                return ((EntityLivingBase)cachedEntity).func_174824_e(partialTicks).func_178788_d(new Vec3d(0.0, (double)((EntityLivingBase)cachedEntity).func_70047_e(), 0.0));
            }
            if (cachedEntity != null) {
                return cachedEntity.func_174824_e(partialTicks);
            }
            return null;
        }
    }

    public static class EntityTarget
    extends CamTarget {
        public Entity cachedEntity;
        public String uuid;

        public EntityTarget() {
        }

        public EntityTarget(Entity entity) {
            this.cachedEntity = entity;
            this.uuid = entity.func_189512_bd();
        }

        @Override
        public Vec3d getTargetVec(World world, float partialTicks) {
            if (this.cachedEntity == null) {
                for (Entity entity : world.func_72910_y()) {
                    if (!entity.func_189512_bd().equals(this.uuid)) continue;
                    this.cachedEntity = entity;
                    break;
                }
            }
            if (this.cachedEntity instanceof EntityLivingBase) {
                return ((EntityLivingBase)this.cachedEntity).func_174824_e(partialTicks).func_178788_d(new Vec3d(0.0, (double)((EntityLivingBase)this.cachedEntity).func_70047_e(), 0.0));
            }
            if (this.cachedEntity != null) {
                return this.cachedEntity.func_174824_e(partialTicks);
            }
            return null;
        }

        @Override
        protected void write(NBTTagCompound nbt) {
            nbt.func_74778_a("uuid", this.uuid);
        }

        @Override
        protected void read(NBTTagCompound nbt) {
            this.uuid = nbt.func_74779_i("uuid");
        }
    }

    public static class BlockTarget
    extends CamTarget {
        public BlockPos pos;

        public BlockTarget() {
        }

        public BlockTarget(BlockPos pos) {
            this.pos = pos;
        }

        @Override
        public Vec3d getTargetVec(World world, float partialTicks) {
            return new Vec3d((double)this.pos.func_177958_n() + 0.5, (double)this.pos.func_177956_o() + 0.5, (double)this.pos.func_177952_p() + 0.5);
        }

        @Override
        protected void write(NBTTagCompound nbt) {
            nbt.func_74783_a("data", new int[]{this.pos.func_177958_n(), this.pos.func_177956_o(), this.pos.func_177952_p()});
        }

        @Override
        protected void read(NBTTagCompound nbt) {
            int[] array = nbt.func_74759_k("data");
            if (array == null || array.length != 3) {
                throw new IllegalArgumentException("Invalid block target data=" + array);
            }
            this.pos = new BlockPos(array[0], array[1], array[2]);
        }
    }
}

