/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.cmdcam.common.utils.math;

import com.creativemd.cmdcam.common.utils.math.Interpolation;
import com.creativemd.cmdcam.common.utils.math.Vec;

public class CosineInterpolation<T extends Vec>
extends Interpolation<T> {
    public CosineInterpolation(T ... points) {
        super(points);
    }

    @Override
    public double valueAt(double mu, int pointIndex, int pointIndexNext, int dim) {
        double mu2 = (1.0 - Math.cos(mu * Math.PI)) / 2.0;
        return this.getValue(pointIndex, dim) * (1.0 - mu2) + this.getValue(pointIndexNext, dim) * mu2;
    }
}

