/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.cmdcam.common.utils.math;

import com.creativemd.cmdcam.common.utils.math.CubicInterpolation;
import com.creativemd.cmdcam.common.utils.math.Vec;

public class HermiteInterpolation<T extends Vec>
extends CubicInterpolation<T> {
    public Tension tension;
    public double bias;

    public HermiteInterpolation(Double[] times, T[] points, double bias, Tension tension) {
        super(times, points);
        this.bias = bias;
        this.tension = tension;
    }

    public HermiteInterpolation(Double[] times, T[] points, Tension tension) {
        this(times, (Vec[])points, 0.0, tension);
    }

    public HermiteInterpolation(Double[] times, T[] points) {
        this(times, (Vec[])points, Tension.Normal);
    }

    public HermiteInterpolation(double bias, Tension tension, T ... points) {
        super(points);
        this.bias = bias;
        this.tension = tension;
    }

    public HermiteInterpolation(Tension tension, T ... points) {
        this(0.0, tension, (Vec[])points);
    }

    public HermiteInterpolation(T ... points) {
        this(Tension.Normal, (Vec[])points);
    }

    @Override
    public double valueAt(double mu, int pointIndex, int pointIndexNext, int dim) {
        double v0 = this.getValue(pointIndex - 1, dim);
        double v1 = this.getValue(pointIndex, dim);
        double v2 = this.getValue(pointIndexNext, dim);
        double v3 = this.getValue(pointIndexNext + 1, dim);
        double mu2 = mu * mu;
        double mu3 = mu2 * mu;
        double m0 = (v1 - v0) * (1.0 + this.bias) * (double)(1 - this.tension.value) / 2.0;
        m0 += (v2 - v1) * (1.0 - this.bias) * (double)(1 - this.tension.value) / 2.0;
        double m1 = (v2 - v1) * (1.0 + this.bias) * (double)(1 - this.tension.value) / 2.0;
        double a0 = 2.0 * mu3 - 3.0 * mu2 + 1.0;
        double a1 = mu3 - 2.0 * mu2 + mu;
        double a2 = mu3 - mu2;
        double a3 = -2.0 * mu3 + 3.0 * mu2;
        return a0 * v1 + a1 * m0 + a2 * (m1 += (v3 - v2) * (1.0 - this.bias) * (double)(1 - this.tension.value) / 2.0) + a3 * v2;
    }

    public static enum Tension {
        High(1),
        Normal(0),
        Low(-1);

        public final int value;

        private Tension(int value) {
            this.value = value;
        }
    }
}

