/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.cmdcam.server;

import com.creativemd.cmdcam.client.mode.CamMode;
import com.creativemd.cmdcam.common.packet.StartPathPacket;
import com.creativemd.cmdcam.common.packet.StopPathPacket;
import com.creativemd.cmdcam.common.utils.CamPath;
import com.creativemd.cmdcam.server.CMDCamServer;
import com.creativemd.creativecore.common.packet.CreativeCorePacket;
import com.creativemd.creativecore.common.packet.PacketHandler;
import com.creativemd.creativecore.common.utils.mc.ChatFormatting;
import java.util.Collection;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;

public class CamCommandServer
extends CommandBase {
    public String func_71517_b() {
        return "cam-server";
    }

    public String func_71518_a(ICommandSender sender) {
        return "used to control the camera (server side)";
    }

    public static long StringToDuration(String input) {
        String replacement = null;
        int factor = 0;
        if (input.endsWith("ms")) {
            replacement = "ms";
            factor = 1;
        } else if (input.endsWith("s")) {
            replacement = "s";
            factor = 1000;
        } else if (input.endsWith("m")) {
            replacement = "m";
            factor = 60000;
        } else if (input.endsWith("h")) {
            replacement = "h";
            factor = 3600000;
        } else if (input.endsWith("d")) {
            replacement = "d";
            factor = 86400000;
        }
        try {
            if (replacement == null) {
                replacement = "";
                factor = 1000;
            }
            return Long.parseLong(input.replaceAll(replacement, "")) * (long)factor;
        }
        catch (Exception exception) {
            return -1L;
        }
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length == 0) {
            sender.func_145747_a((ITextComponent)new TextComponentString("" + ChatFormatting.BOLD + ChatFormatting.YELLOW + "/cam-server start <player> <path> [" + String.join((CharSequence)":", CamMode.modes.keySet()) + "] [time|ms|s|m|h|d] [loops (-1 -> endless)] " + ChatFormatting.RED + "starts the animation"));
            sender.func_145747_a((ITextComponent)new TextComponentString("" + ChatFormatting.BOLD + ChatFormatting.YELLOW + "/cam-server stop <player> " + ChatFormatting.RED + "stops the animation"));
            sender.func_145747_a((ITextComponent)new TextComponentString("" + ChatFormatting.BOLD + ChatFormatting.YELLOW + "/cam-server list " + ChatFormatting.RED + "lists all saved paths"));
            sender.func_145747_a((ITextComponent)new TextComponentString("" + ChatFormatting.BOLD + ChatFormatting.YELLOW + "/cam-server remove <name> " + ChatFormatting.RED + "removes the given path"));
            sender.func_145747_a((ITextComponent)new TextComponentString("" + ChatFormatting.BOLD + ChatFormatting.YELLOW + "/cam-server clear " + ChatFormatting.RED + "clears all saved paths"));
        } else {
            String subCommand = args[0];
            if (subCommand.equals("start")) {
                if (args.length >= 3) {
                    List players = CamCommandServer.func_193513_a((MinecraftServer)server, (ICommandSender)sender, (String)args[1]);
                    CamPath path = CMDCamServer.getPath(sender.func_130014_f_(), args[2]);
                    if (path != null) {
                        if (args.length >= 4) {
                            path.mode = args[3];
                            if (args.length >= 5) {
                                path = path.copy();
                                long duration = CamCommandServer.StringToDuration(args[4]);
                                if (duration <= 0L) {
                                    sender.func_145747_a((ITextComponent)new TextComponentString("Invalid time '" + args[4] + "'!"));
                                    return;
                                }
                                path.duration = duration;
                                if (args.length >= 6) {
                                    path.currentLoop = Integer.parseInt(args[5]);
                                }
                            }
                        }
                        PacketHandler.sendPacketToPlayers((CreativeCorePacket)new StartPathPacket(path), (Iterable)players);
                    } else {
                        sender.func_145747_a((ITextComponent)new TextComponentString("Path '" + args[2] + "' could not be found!"));
                    }
                } else {
                    sender.func_145747_a((ITextComponent)new TextComponentString("" + ChatFormatting.BOLD + ChatFormatting.YELLOW + "/cam-server start <player> <path> [" + String.join((CharSequence)":", CamMode.modes.keySet()) + "] [time|ms|s|m|h|d] [loops (-1 -> endless)] " + ChatFormatting.RED + "starts the animation"));
                }
            }
            if (subCommand.equals("stop")) {
                if (args.length >= 2) {
                    PacketHandler.sendPacketToPlayers((CreativeCorePacket)new StopPathPacket(), (Iterable)CamCommandServer.func_193513_a((MinecraftServer)server, (ICommandSender)sender, (String)args[1]));
                } else {
                    sender.func_145747_a((ITextComponent)new TextComponentString("" + ChatFormatting.BOLD + ChatFormatting.YELLOW + "/cam-server stop <player> " + ChatFormatting.RED + "stops the animation"));
                }
            }
            if (subCommand.equals("list")) {
                Collection<String> names = CMDCamServer.getSavedPaths(sender.func_130014_f_());
                String output = "There are " + names.size() + " path(s) in total. ";
                for (String key : names) {
                    output = output + key + ", ";
                }
                sender.func_145747_a((ITextComponent)new TextComponentString(output));
            }
            if (subCommand.equals("remove")) {
                if (args.length >= 2) {
                    if (CMDCamServer.removePath(sender.func_130014_f_(), args[1])) {
                        sender.func_145747_a((ITextComponent)new TextComponentString("Path '" + args[2] + "' has been removed!"));
                    } else {
                        sender.func_145747_a((ITextComponent)new TextComponentString("Path '" + args[2] + "' could not be found!"));
                    }
                } else {
                    sender.func_145747_a((ITextComponent)new TextComponentString("" + ChatFormatting.BOLD + ChatFormatting.YELLOW + "/cam-server remove <name> " + ChatFormatting.RED + "lists all saved paths"));
                }
            }
            if (subCommand.equals("clear")) {
                CMDCamServer.clearPaths(sender.func_130014_f_());
                sender.func_145747_a((ITextComponent)new TextComponentString("Removed all existing paths (in this world)!"));
            }
        }
    }
}

