/*
 * Decompiled with CFR 0.152.
 */
package team.creative.cmdcam.client.interpolation;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import org.apache.commons.lang3.ArrayUtils;
import team.creative.cmdcam.client.PathParseException;
import team.creative.cmdcam.client.interpolation.HermiteMovement;
import team.creative.cmdcam.common.util.CamPoint;
import team.creative.cmdcam.common.util.CamTarget;
import team.creative.cmdcam.common.util.interpolation.HermiteInterpolation;
import team.creative.creativecore.common.util.math.matrix.Matrix3;
import team.creative.creativecore.common.util.math.vec.Vector;
import team.creative.creativecore.common.util.math.vec.Vector1;
import team.creative.creativecore.common.util.math.vec.Vector3;

public class CircularMovement
extends HermiteMovement {
    private static Minecraft mc = Minecraft.func_71410_x();
    public Vector3 sphereOrigin;
    public double radius;
    public CamTarget target;
    public HermiteInterpolation<Vector1> yAxis;

    @Override
    public void initMovement(List<CamPoint> points, int loops, CamTarget target) throws PathParseException {
        ArrayList<CamPoint> newPointsSorted;
        ArrayList<Double> times;
        ArrayList<Vector1> vecs;
        Vector3 firstPoint;
        if (target == null) {
            throw new PathParseException("No target found");
        }
        Vec3d center = target.getTargetVec((World)CircularMovement.mc.field_71441_e, mc.func_184121_ak());
        if (center != null) {
            points.add(points.get(0));
            this.target = target;
            firstPoint = new Vector3(points.get((int)0).x, points.get((int)0).y, points.get((int)0).z);
            Vector3 centerPoint = new Vector3(center.field_72450_a, center.field_72448_b, center.field_72449_c);
            this.sphereOrigin = new Vector3(firstPoint);
            this.sphereOrigin.sub(centerPoint);
            this.radius = this.sphereOrigin.length();
            vecs = new ArrayList<Vector1>();
            times = new ArrayList<Double>();
            times.add(0.0);
            vecs.add(new Vector1(firstPoint.y));
            newPointsSorted = new ArrayList<CamPoint>();
            newPointsSorted.add(points.get(0));
            for (int i = 1; i < points.size() - 1; ++i) {
                Vector3 point = new Vector3(points.get((int)i).x, firstPoint.y, points.get((int)i).z);
                point.sub(centerPoint);
                double dot = point.dot(this.sphereOrigin);
                double det = point.x * this.sphereOrigin.z - point.z * this.sphereOrigin.x;
                double angle = Math.toDegrees(Math.atan2(det, dot));
                if (angle < 0.0) {
                    angle += 360.0;
                }
                double time = angle / 360.0;
                for (int j = 0; j < times.size(); ++j) {
                    if (!((Double)times.get(j) > time)) continue;
                    times.add(j, time);
                    vecs.add(j, new Vector1(points.get((int)i).y));
                    newPointsSorted.add(j, points.get(i));
                    break;
                }
                newPointsSorted.add(points.get(i));
                times.add(time);
                vecs.add(new Vector1(points.get((int)i).y));
            }
            if (loops == 0) {
                newPointsSorted.add(((CamPoint)newPointsSorted.get(0)).copy());
            }
        } else {
            throw new PathParseException("Invalid target");
        }
        times.add(1.0);
        vecs.add(new Vector1(firstPoint.y));
        this.yAxis = new HermiteInterpolation(ArrayUtils.toPrimitive((Double[])times.toArray(new Double[0])), (Vector[])vecs.toArray(new Vector1[0]));
        super.initMovement(times.toArray(new Double[0]), newPointsSorted, loops, target);
    }

    @Override
    public CamPoint getPointInBetween(CamPoint point1, CamPoint point2, double percent, double wholeProgress, boolean isFirstLoop, boolean isLastLoop) {
        CamPoint newCamPoint = super.getPointInBetween(point1, point2, percent, wholeProgress, isFirstLoop, isLastLoop);
        double angle = wholeProgress * 360.0;
        Vec3d center = this.target.getTargetVec((World)CircularMovement.mc.field_71441_e, mc.func_184121_ak());
        if (center != null) {
            Vector3 centerPoint = new Vector3(center.field_72450_a, center.field_72448_b, center.field_72449_c);
            Vector3 newPoint = new Vector3(this.sphereOrigin);
            newPoint.y = 0.0;
            Matrix3 matrix = new Matrix3();
            matrix.rotY(Math.toRadians(angle));
            matrix.transform(newPoint);
            newPoint.y = ((Vector1)this.yAxis.valueAt((double)wholeProgress)).x - center.field_72448_b;
            newPoint.normalize();
            newPoint.scale(this.radius);
            newPoint.add(centerPoint);
            newCamPoint.x = newPoint.x;
            newCamPoint.y = newPoint.y;
            newCamPoint.z = newPoint.z;
        }
        return newCamPoint;
    }

    @Override
    public Vector3 getColor() {
        return new Vector3(1.0, 1.0, 0.0);
    }
}

