/*
 * Decompiled with CFR 0.152.
 */
package team.creative.cmdcam.client.mode;

import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import team.creative.cmdcam.client.CamEventHandlerClient;
import team.creative.cmdcam.client.interpolation.CamInterpolation;
import team.creative.cmdcam.client.mode.DefaultMode;
import team.creative.cmdcam.client.mode.OutsideMode;
import team.creative.cmdcam.common.util.CamPath;
import team.creative.cmdcam.common.util.CamPoint;

@OnlyIn(value=Dist.CLIENT)
public abstract class CamMode {
    protected static Minecraft mc = Minecraft.func_71410_x();
    public static HashMap<String, CamMode> modes = new HashMap();
    public final CamPath path;
    public double lastYaw;
    public double lastPitch;

    public static void registerPath(String id, CamMode path) {
        modes.put(id, path);
    }

    public static CamMode getMode(String id) {
        return modes.get(id.toLowerCase());
    }

    public CamMode(CamPath path) {
        this.path = path;
        if (path != null) {
            this.lastPitch = path.tempPoints.get((int)0).rotationPitch;
            this.lastYaw = path.tempPoints.get((int)0).rotationYaw;
        }
    }

    public abstract CamMode createMode(CamPath var1);

    public CamPoint getCamPoint(CamPoint point1, CamPoint point2, double percent, double wholeProgress, float renderTickTime, boolean isFirstLoop, boolean isLastLoop) {
        CamPoint newPoint = this.path.cachedInterpolation.getPointInBetween(point1, point2, percent, wholeProgress, isFirstLoop, isLastLoop);
        if (this.path.target != null) {
            newPoint.rotationPitch = this.lastPitch;
            newPoint.rotationYaw = this.lastYaw;
            Vec3d pos = this.path.target.getTargetVec((World)CamMode.mc.field_71441_e, mc.func_184121_ak());
            if (pos != null) {
                long timeSinceLastRenderFrame = System.nanoTime() - CamEventHandlerClient.lastRenderTime;
                newPoint.faceEntity(pos, 1.0E-8f, 1.0E-8f, (double)timeSinceLastRenderFrame / 6.0E8 * this.path.cameraFollowSpeed);
            }
            this.lastPitch = newPoint.rotationPitch;
            this.lastYaw = newPoint.rotationYaw;
        }
        return newPoint;
    }

    public void onPathStart() {
    }

    public void onPathFinish() {
        CamEventHandlerClient.fov = CamEventHandlerClient.defaultfov;
        CamMode.mc.field_71474_y.field_74334_X = CamEventHandlerClient.defaultfov;
        CamEventHandlerClient.roll = 0.0f;
    }

    public abstract String getDescription();

    public void processPoint(CamPoint point) {
        CamEventHandlerClient.roll = (float)point.roll;
        CamMode.mc.field_71474_y.field_74334_X = (float)point.zoom;
    }

    public static CamPoint getPoint(CamInterpolation movement, ArrayList<CamPoint> points, double percent, int currentLoop, int loops) {
        double lengthOfPoint = 1.0 / (double)(points.size() - 1);
        int currentPoint = Math.min((int)(percent / lengthOfPoint), points.size() - 2);
        CamPoint point1 = points.get(currentPoint);
        CamPoint point2 = points.get(currentPoint + 1);
        return movement.getPointInBetween(point1, point2, percent - (double)currentPoint * lengthOfPoint, percent, currentLoop == 0, currentLoop == loops);
    }

    static {
        CamMode.registerPath("default", new DefaultMode(null));
        CamMode.registerPath("outside", new OutsideMode(null));
    }
}

