/*
 * Decompiled with CFR 0.152.
 */
package team.creative.cmdcam.client.interpolation;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import team.creative.cmdcam.client.PathParseException;
import team.creative.cmdcam.client.interpolation.CircularMovement;
import team.creative.cmdcam.client.interpolation.CubicMovement;
import team.creative.cmdcam.client.interpolation.HermiteMovement;
import team.creative.cmdcam.client.interpolation.LinearMovement;
import team.creative.cmdcam.client.interpolation.SmoothMovement;
import team.creative.cmdcam.common.util.CamPoint;
import team.creative.cmdcam.common.util.CamTarget;
import team.creative.creativecore.common.util.math.vec.Vector3;

public abstract class CamInterpolation {
    public static HashMap<String, CamInterpolation> interpolationTypes = new HashMap();
    public static LinearMovement linear = new LinearMovement();
    public static SmoothMovement cosine = new SmoothMovement();
    public static CubicMovement cubic = new CubicMovement();
    public static HermiteMovement hermite = new HermiteMovement();
    public static CircularMovement circular = new CircularMovement();
    public boolean isRenderingEnabled = false;

    public static CamInterpolation getInterpolationOrDefault(String interpolation) {
        return interpolationTypes.getOrDefault(interpolation, hermite);
    }

    public static CamInterpolation getInterpolation(String interpolation) {
        return interpolationTypes.get(interpolation.toLowerCase());
    }

    public static void registerInterpolation(String name, CamInterpolation interpolation) {
        interpolationTypes.put(name, interpolation);
    }

    public static String[] getMovementNames() {
        String[] names = new String[interpolationTypes.size()];
        int i = 0;
        Iterator<String> iterator = interpolationTypes.keySet().iterator();
        while (iterator.hasNext()) {
            String name;
            names[i] = name = iterator.next();
            ++i;
        }
        return names;
    }

    public abstract Vector3 getColor();

    public abstract void initMovement(List<CamPoint> var1, int var2, CamTarget var3) throws PathParseException;

    public abstract CamPoint getPointInBetween(CamPoint var1, CamPoint var2, double var3, double var5, boolean var7, boolean var8);

    static {
        CamInterpolation.registerInterpolation("linear", linear);
        CamInterpolation.registerInterpolation("cubic", cubic);
        CamInterpolation.registerInterpolation("hermite", hermite);
        CamInterpolation.registerInterpolation("cosine", cosine);
        CamInterpolation.registerInterpolation("circular", circular);
    }
}

