/*
 * Decompiled with CFR 0.152.
 */
package team.creative.cmdcam;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.realmsclient.gui.ChatFormatting;
import java.util.Collection;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.ArgumentSerializer;
import net.minecraft.command.arguments.ArgumentTypes;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.command.arguments.IArgumentSerializer;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import team.creative.cmdcam.client.CMDCamClient;
import team.creative.cmdcam.common.command.argument.CamModeArgument;
import team.creative.cmdcam.common.command.argument.DurationArgument;
import team.creative.cmdcam.common.command.argument.InterpolationArgument;
import team.creative.cmdcam.common.command.argument.TargetArgument;
import team.creative.cmdcam.common.packet.ConnectPacket;
import team.creative.cmdcam.common.packet.GetPathPacket;
import team.creative.cmdcam.common.packet.SetPathPacket;
import team.creative.cmdcam.common.packet.StartPathPacket;
import team.creative.cmdcam.common.packet.StopPathPacket;
import team.creative.cmdcam.common.utils.CamPath;
import team.creative.cmdcam.server.CMDCamServer;
import team.creative.creativecore.common.network.CreativeNetwork;
import team.creative.creativecore.common.network.CreativePacket;

@Mod(value="cmdcam")
public class CMDCam {
    public static final String MODID = "cmdcam";
    private static final Logger LOGGER = LogManager.getLogger((String)"cmdcam");
    public static CreativeNetwork NETWORK;

    public CMDCam() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::init);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::client);
        MinecraftForge.EVENT_BUS.addListener(this::serverStarting);
    }

    private void client(FMLClientSetupEvent event) {
        CMDCamClient.init(event);
    }

    private void init(FMLCommonSetupEvent event) {
        NETWORK = new CreativeNetwork("1.0", LOGGER, new ResourceLocation(MODID, "main"));
        NETWORK.registerType(ConnectPacket.class);
        NETWORK.registerType(GetPathPacket.class);
        NETWORK.registerType(SetPathPacket.class);
        NETWORK.registerType(StartPathPacket.class);
        NETWORK.registerType(StopPathPacket.class);
        ArgumentTypes.func_218136_a((String)"duration", DurationArgument.class, (IArgumentSerializer)new ArgumentSerializer(() -> DurationArgument.duration()));
        ArgumentTypes.func_218136_a((String)"cameramode", CamModeArgument.class, (IArgumentSerializer)new ArgumentSerializer(() -> CamModeArgument.mode()));
        ArgumentTypes.func_218136_a((String)"cameratarget", TargetArgument.class, (IArgumentSerializer)new ArgumentSerializer(() -> TargetArgument.target()));
        ArgumentTypes.func_218136_a((String)"interpolation", InterpolationArgument.class, (IArgumentSerializer)new ArgumentSerializer(() -> InterpolationArgument.interpolation()));
        ArgumentTypes.func_218136_a((String)"allinterpolation", InterpolationArgument.AllInterpolationArgument.class, (IArgumentSerializer)new ArgumentSerializer(() -> InterpolationArgument.interpolationAll()));
    }

    private void serverStarting(FMLServerStartingEvent event) {
        event.getCommandDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"cam-server").executes(x -> {
            ((CommandSource)x.getSource()).func_197030_a((ITextComponent)new StringTextComponent("" + ChatFormatting.BOLD + ChatFormatting.YELLOW + "/cam-server start <player> <path> [time|ms|s|m|h|d] [loops (-1 -> endless)] " + ChatFormatting.RED + "starts the animation"), false);
            ((CommandSource)x.getSource()).func_197030_a((ITextComponent)new StringTextComponent("" + ChatFormatting.BOLD + ChatFormatting.YELLOW + "/cam-server stop <player> " + ChatFormatting.RED + "stops the animation"), false);
            ((CommandSource)x.getSource()).func_197030_a((ITextComponent)new StringTextComponent("" + ChatFormatting.BOLD + ChatFormatting.YELLOW + "/cam-server list " + ChatFormatting.RED + "lists all saved paths"), false);
            ((CommandSource)x.getSource()).func_197030_a((ITextComponent)new StringTextComponent("" + ChatFormatting.BOLD + ChatFormatting.YELLOW + "/cam-server remove <name> " + ChatFormatting.RED + "removes the given path"), false);
            ((CommandSource)x.getSource()).func_197030_a((ITextComponent)new StringTextComponent("" + ChatFormatting.BOLD + ChatFormatting.YELLOW + "/cam-server clear " + ChatFormatting.RED + "clears all saved paths"), false);
            return 0;
        })).then(Commands.func_197057_a((String)"start").then(Commands.func_197056_a((String)"players", (ArgumentType)EntityArgument.func_197094_d()).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"name", (ArgumentType)StringArgumentType.string()).executes(x -> {
            Collection players = EntityArgument.func_197090_e((CommandContext)x, (String)"players");
            if (players.isEmpty()) {
                return 0;
            }
            String pathName = StringArgumentType.getString((CommandContext)x, (String)"name");
            CamPath path = CMDCamServer.getPath((World)((CommandSource)x.getSource()).func_197023_e(), pathName);
            if (path != null) {
                StartPathPacket packet = new StartPathPacket(path);
                for (ServerPlayerEntity player : players) {
                    NETWORK.sendToClient((CreativePacket)packet, player);
                }
            } else {
                ((CommandSource)x.getSource()).func_197030_a((ITextComponent)new StringTextComponent("Path '" + pathName + "' could not be found!"), true);
            }
            return 0;
        })).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"duration", (ArgumentType)DurationArgument.duration()).executes(x -> {
            Collection players = EntityArgument.func_197090_e((CommandContext)x, (String)"players");
            if (players.isEmpty()) {
                return 0;
            }
            String pathName = StringArgumentType.getString((CommandContext)x, (String)"name");
            CamPath path = CMDCamServer.getPath((World)((CommandSource)x.getSource()).func_197023_e(), pathName);
            if (path != null) {
                path = path.copy();
                long duration = DurationArgument.getDuration(x, "duration");
                if (duration > 0L) {
                    path.duration = duration;
                }
                StartPathPacket packet = new StartPathPacket(path);
                for (ServerPlayerEntity player : players) {
                    NETWORK.sendToClient((CreativePacket)packet, player);
                }
            } else {
                ((CommandSource)x.getSource()).func_197030_a((ITextComponent)new StringTextComponent("Path '" + pathName + "' could not be found!"), true);
            }
            return 0;
        })).then(Commands.func_197056_a((String)"loop", (ArgumentType)IntegerArgumentType.integer((int)-1)).executes(x -> {
            Collection players = EntityArgument.func_197090_e((CommandContext)x, (String)"players");
            if (players.isEmpty()) {
                return 0;
            }
            String pathName = StringArgumentType.getString((CommandContext)x, (String)"name");
            CamPath path = CMDCamServer.getPath((World)((CommandSource)x.getSource()).func_197023_e(), pathName);
            if (path != null) {
                path = path.copy();
                long duration = DurationArgument.getDuration(x, "duration");
                if (duration > 0L) {
                    path.duration = duration;
                }
                path.currentLoop = IntegerArgumentType.getInteger((CommandContext)x, (String)"loop");
                StartPathPacket packet = new StartPathPacket(path);
                for (ServerPlayerEntity player : players) {
                    NETWORK.sendToClient((CreativePacket)packet, player);
                }
            } else {
                ((CommandSource)x.getSource()).func_197030_a((ITextComponent)new StringTextComponent("Path '" + pathName + "' could not be found!"), true);
            }
            return 0;
        }))))))).then(Commands.func_197057_a((String)"stop").then(Commands.func_197056_a((String)"players", (ArgumentType)EntityArgument.func_197094_d()).executes(x -> {
            StopPathPacket packet = new StopPathPacket();
            for (ServerPlayerEntity player : EntityArgument.func_197090_e((CommandContext)x, (String)"players")) {
                NETWORK.sendToClient((CreativePacket)packet, player);
            }
            return 0;
        })))).then(Commands.func_197057_a((String)"list").executes(x -> {
            Collection<String> names = CMDCamServer.getSavedPaths((World)((CommandSource)x.getSource()).func_197023_e());
            String output = "There are " + names.size() + " path(s) in total. ";
            for (String key : names) {
                output = output + key + ", ";
            }
            ((CommandSource)x.getSource()).func_197030_a((ITextComponent)new StringTextComponent(output), true);
            return 0;
        }))).then(Commands.func_197057_a((String)"clear").executes(x -> {
            CMDCamServer.clearPaths((World)((CommandSource)x.getSource()).func_197023_e());
            ((CommandSource)x.getSource()).func_197030_a((ITextComponent)new StringTextComponent("Removed all existing paths (in this world)!"), true);
            return 0;
        }))).then(Commands.func_197057_a((String)"remove").then(Commands.func_197056_a((String)"name", (ArgumentType)StringArgumentType.string()).executes(x -> {
            String path = StringArgumentType.getString((CommandContext)x, (String)"name");
            if (CMDCamServer.removePath((World)((CommandSource)x.getSource()).func_197023_e(), path)) {
                ((CommandSource)x.getSource()).func_197030_a((ITextComponent)new StringTextComponent("Path '" + path + "' has been removed!"), true);
            } else {
                ((CommandSource)x.getSource()).func_197030_a((ITextComponent)new StringTextComponent("Path '" + path + "' could not be found!"), true);
            }
            return 0;
        }))));
    }
}

