/*
 * Decompiled with CFR 0.152.
 */
package team.creative.cmdcam.client.interpolation;

import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Matrix3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import net.minecraft.client.Minecraft;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import org.apache.commons.lang3.ArrayUtils;
import team.creative.cmdcam.client.PathParseException;
import team.creative.cmdcam.client.interpolation.HermiteMovement;
import team.creative.cmdcam.common.utils.CamPoint;
import team.creative.cmdcam.common.utils.CamTarget;
import team.creative.cmdcam.common.utils.interpolation.HermiteInterpolation;
import team.creative.cmdcam.common.utils.vec.Vec;
import team.creative.cmdcam.common.utils.vec.Vec1;
import team.creative.cmdcam.common.utils.vec.Vec3;

public class CircularMovement
extends HermiteMovement {
    private static Minecraft mc = Minecraft.func_71410_x();
    public Vector3d sphereOrigin;
    public double radius;
    public CamTarget target;
    public HermiteInterpolation<Vec1> yAxis;

    @Override
    public void initMovement(List<CamPoint> points, int loops, CamTarget target) throws PathParseException {
        ArrayList<CamPoint> newPointsSorted;
        ArrayList<Double> times;
        ArrayList<Vec1> vecs;
        Vector3d firstPoint;
        if (target == null) {
            throw new PathParseException("No target found");
        }
        Vec3d center = target.getTargetVec((World)CircularMovement.mc.field_71441_e, mc.func_184121_ak());
        if (center != null) {
            points.add(points.get(0));
            this.target = target;
            firstPoint = new Vector3d(points.get((int)0).x, points.get((int)0).y, points.get((int)0).z);
            Vector3d centerPoint = new Vector3d(center.field_72450_a, center.field_72448_b, center.field_72449_c);
            this.sphereOrigin = new Vector3d(firstPoint);
            this.sphereOrigin.sub((Tuple3d)centerPoint);
            this.radius = this.sphereOrigin.length();
            vecs = new ArrayList<Vec1>();
            times = new ArrayList<Double>();
            times.add(0.0);
            vecs.add(new Vec1(firstPoint.y));
            newPointsSorted = new ArrayList<CamPoint>();
            newPointsSorted.add(points.get(0));
            for (int i = 1; i < points.size() - 1; ++i) {
                Vector3d point = new Vector3d(points.get((int)i).x, firstPoint.y, points.get((int)i).z);
                point.sub((Tuple3d)centerPoint);
                double dot = point.dot(this.sphereOrigin);
                double det = point.x * this.sphereOrigin.z - point.z * this.sphereOrigin.x;
                double angle = Math.toDegrees(Math.atan2(det, dot));
                if (angle < 0.0) {
                    angle += 360.0;
                }
                double time = angle / 360.0;
                for (int j = 0; j < times.size(); ++j) {
                    if (!((Double)times.get(j) > time)) continue;
                    times.add(j, time);
                    vecs.add(j, new Vec1(points.get((int)i).y));
                    newPointsSorted.add(j, points.get(i));
                    break;
                }
                newPointsSorted.add(points.get(i));
                times.add(time);
                vecs.add(new Vec1(points.get((int)i).y));
            }
            if (loops == 0) {
                newPointsSorted.add(((CamPoint)newPointsSorted.get(0)).copy());
            }
        } else {
            throw new PathParseException("Invalid target");
        }
        times.add(1.0);
        vecs.add(new Vec1(firstPoint.y));
        this.yAxis = new HermiteInterpolation(ArrayUtils.toPrimitive((Double[])times.toArray(new Double[0])), (Vec[])vecs.toArray(new Vec1[0]));
        super.initMovement(times.toArray(new Double[0]), newPointsSorted, loops, target);
    }

    @Override
    public CamPoint getPointInBetween(CamPoint point1, CamPoint point2, double percent, double wholeProgress, boolean isFirstLoop, boolean isLastLoop) {
        CamPoint newCamPoint = super.getPointInBetween(point1, point2, percent, wholeProgress, isFirstLoop, isLastLoop);
        double angle = wholeProgress * 360.0;
        Vec3d center = this.target.getTargetVec((World)CircularMovement.mc.field_71441_e, mc.func_184121_ak());
        if (center != null) {
            Vector3d centerPoint = new Vector3d(center.field_72450_a, center.field_72448_b, center.field_72449_c);
            Vector3d newPoint = new Vector3d(this.sphereOrigin);
            newPoint.y = 0.0;
            Matrix3d matrix = new Matrix3d();
            matrix.rotY(Math.toRadians(angle));
            matrix.transform((Tuple3d)newPoint);
            newPoint.y = ((Vec1)this.yAxis.valueAt((double)wholeProgress)).x - center.field_72448_b;
            newPoint.normalize();
            newPoint.scale(this.radius);
            newPoint.add((Tuple3d)centerPoint);
            newCamPoint.x = newPoint.x;
            newCamPoint.y = newPoint.y;
            newCamPoint.z = newPoint.z;
        }
        return newCamPoint;
    }

    @Override
    public Vec3 getColor() {
        return new Vec3(1.0, 1.0, 0.0);
    }
}

