/*
 * Decompiled with CFR 0.152.
 */
package team.creative.cmdcam.common.utils.interpolation;

import team.creative.cmdcam.common.utils.interpolation.Interpolation;
import team.creative.cmdcam.common.utils.vec.Vec;

public class CubicInterpolation<T extends Vec>
extends Interpolation<T> {
    public T beginVec;
    public T endVec;

    public CubicInterpolation(double[] times, T[] points) {
        super(times, points);
        this.beginVec = ((Vec)points[0]).add((Vec)((Vec)points[0]).sub((Vec)points[1]));
        this.endVec = ((Vec)points[points.length - 1]).add((Vec)((Vec)points[points.length - 1]).sub((Vec)points[points.length - 2]));
    }

    public CubicInterpolation(T ... points) {
        super(points);
        this.beginVec = ((Vec)points[0]).add((Vec)((Vec)points[0]).sub((Vec)points[1]));
        this.endVec = ((Vec)points[points.length - 1]).add((Vec)((Vec)points[points.length - 1]).sub((Vec)points[points.length - 2]));
    }

    @Override
    protected double getValue(int index, int dim) {
        if (index < 0) {
            return ((Vec)this.beginVec).getValueByDim(dim);
        }
        if (index >= this.points.size()) {
            return ((Vec)this.endVec).getValueByDim(dim);
        }
        return ((Vec)this.pointVecs.get(index)).getValueByDim(dim);
    }

    @Override
    public double valueAt(double mu, int pointIndex, int pointIndexNext, int dim) {
        double v0 = this.getValue(pointIndex - 1, dim);
        double v1 = this.getValue(pointIndex, dim);
        double v2 = this.getValue(pointIndexNext, dim);
        double v3 = this.getValue(pointIndexNext + 1, dim);
        double mu2 = mu * mu;
        double a0 = v3 - v2 - v0 + v1;
        double a1 = v0 - v1 - a0;
        double a2 = v2 - v0;
        double a3 = v1;
        return a0 * mu * mu2 + a1 * mu2 + a2 * mu + a3;
    }
}

