/*
 * Decompiled with CFR 0.152.
 */
package team.creative.cmdcam.common.utils.interpolation;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import team.creative.cmdcam.common.utils.vec.Vec;

public abstract class Interpolation<T extends Vec> {
    protected LinkedHashMap<Double, T> points = new LinkedHashMap();
    protected ArrayList<T> pointVecs = new ArrayList();
    private final Class classOfT;

    public Interpolation(double[] times, T[] points) {
        if (points.length < 2) {
            throw new IllegalArgumentException("At least two points are needed!");
        }
        if (times.length != points.length) {
            throw new IllegalArgumentException("Invalid times array!");
        }
        this.classOfT = points[0].getClass();
        for (int i = 0; i < points.length; ++i) {
            this.points.put(times[i], points[i]);
        }
        this.pointVecs = new ArrayList<T>(this.points.values());
    }

    public Interpolation(T ... points) {
        if (points.length < 2) {
            throw new IllegalArgumentException("At least two points are needed!");
        }
        this.classOfT = points[0].getClass();
        double time = 0.0;
        double stepLength = 1.0 / (double)(points.length - 1);
        for (int i = 0; i < points.length; ++i) {
            this.points.put(time, points[i]);
            time += stepLength;
        }
        this.pointVecs = new ArrayList<T>(this.points.values());
    }

    protected double getValue(int index, int dim) {
        return ((Vec)this.pointVecs.get(index)).getValueByDim(dim);
    }

    public T valueAt(double t) {
        if (t >= 0.0 && t <= 1.0) {
            Map.Entry<Double, T> firstPoint = null;
            int indexFirst = -1;
            Map.Entry<Double, T> secondPoint = null;
            int indexSecond = -1;
            int i = 0;
            for (Map.Entry<Double, T> entry : this.points.entrySet()) {
                if (entry.getKey() >= t) {
                    if (firstPoint == null) {
                        firstPoint = entry;
                        indexFirst = i;
                        break;
                    }
                    secondPoint = entry;
                    indexSecond = i;
                    break;
                }
                firstPoint = entry;
                indexFirst = i++;
            }
            if (secondPoint == null) {
                return ((Vec)firstPoint.getValue()).copy();
            }
            Vec vec = Vec.copyVec((Vec)firstPoint.getValue());
            double pointDistance = (Double)secondPoint.getKey() - firstPoint.getKey();
            double mu = (t - firstPoint.getKey()) / pointDistance;
            for (int dim = 0; dim < vec.getDimensionCount(); ++dim) {
                vec.setValueByDim(dim, this.valueAt(mu, indexFirst, indexSecond, dim));
            }
            return (T)vec;
        }
        return (T)Vec.createEmptyVec(this.classOfT);
    }

    public abstract double valueAt(double var1, int var3, int var4, int var5);
}

