/*
 * Decompiled with CFR 0.152.
 */
package minetweaker.mc1102.actions;

import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class SetBlockHardnessAction
implements IUndoableAction {
    private final ItemStack stack;
    private final float hardness;
    private final float oldHardness;

    public SetBlockHardnessAction(ItemStack stack, float hardness) {
        this.stack = stack;
        this.hardness = hardness;
        this.oldHardness = Block.func_149634_a((Item)stack.func_77973_b()).func_176195_g(null, null, null);
    }

    private static void set(ItemStack stack, float hardness) {
        if (SetBlockHardnessAction.isBlock(stack)) {
            Block block = Block.func_149634_a((Item)stack.func_77973_b());
            block.func_149711_c(hardness);
        } else {
            MineTweakerAPI.logError("Item is not a block");
        }
    }

    public static boolean isBlock(ItemStack stack) {
        ResourceLocation name = (ResourceLocation)Block.field_149771_c.func_177774_c((Object)Block.func_149634_a((Item)stack.func_77973_b()));
        return !name.toString().equals("minecraft:air") && Block.field_149771_c.func_148741_d((Object)name);
    }

    @Override
    public void apply() {
        if (SetBlockHardnessAction.isBlock(this.stack)) {
            SetBlockHardnessAction.set(this.stack, this.hardness);
        }
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public void undo() {
        if (SetBlockHardnessAction.isBlock(this.stack)) {
            SetBlockHardnessAction.set(this.stack, this.oldHardness);
        }
    }

    @Override
    public String describe() {
        if (SetBlockHardnessAction.isBlock(this.stack)) {
            return "Setting hardness of " + this.stack.func_82833_r() + " to " + this.hardness;
        }
        return "Unable to set hardness of " + this.stack.func_82833_r() + " because it is an Item";
    }

    @Override
    public String describeUndo() {
        if (SetBlockHardnessAction.isBlock(this.stack)) {
            return "Reverting hardness of " + this.stack.func_82833_r() + " to " + this.oldHardness;
        }
        return "Unable to revert hardness of " + this.stack.func_82833_r() + " because it is an Item";
    }

    @Override
    public Object getOverrideKey() {
        return null;
    }
}

