/*
 * Decompiled with CFR 0.152.
 */
package minetweaker.mc1102.util;

import net.minecraft.entity.EntityLivingBase;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;

public class MineTweakerPlatformUtils {
    private MineTweakerPlatformUtils() {
    }

    public static Class<? extends EntityLivingBase> getLivingEntityClass(String entityClassName) {
        try {
            Class<?> entityClass = Class.forName(entityClassName);
            if (!EntityLivingBase.class.isAssignableFrom(entityClass)) {
                throw new RuntimeException("Not an entity class: " + entityClassName);
            }
            return entityClass;
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException("entity class not found: " + entityClassName);
        }
    }

    public static String getLanguage() {
        return FMLCommonHandler.instance().getSide() == Side.SERVER ? null : FMLClientHandler.instance().getCurrentLanguage();
    }

    public static boolean isLanguageActive(String lang) {
        String current = MineTweakerPlatformUtils.getLanguage();
        return current != null && current.equals(lang);
    }

    public static boolean isClient() {
        return FMLCommonHandler.instance().getSide() == Side.CLIENT;
    }
}

