/*
 * Decompiled with CFR 0.152.
 */
package minetweaker.mods.ic2.crops;

import ic2.api.crops.CropCard;
import ic2.api.crops.CropProperties;
import ic2.api.crops.ICropTile;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IItemStack;
import minetweaker.api.minecraft.MineTweakerMC;
import minetweaker.mods.ic2.crops.GrowthRequirements;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenGetter;
import stanhebben.zenscript.annotations.ZenMethod;
import stanhebben.zenscript.annotations.ZenSetter;

@ZenClass(value="mods.ic2.SyntheticCrop")
public class SyntheticCrop
extends CropCard {
    private String name;
    private String owner;
    private int tier;
    private int[] stats = new int[4];
    private String[] attributes;
    private int maxSize;
    private float dropChance;
    private IItemStack fruit;
    private GrowthRequirements reqs;
    private CropProperties properties;

    public SyntheticCrop(String cropName, String cropOwner) {
        this.name = cropName;
    }

    @ZenGetter(value="name")
    public String getName() {
        return this.name;
    }

    @ZenGetter(value="owner")
    public String getOwner() {
        return this.owner;
    }

    @ZenGetter(value="properties")
    public CropProperties getProperties() {
        return this.properties;
    }

    @ZenSetter(value="properties")
    public void setProperties(CropProperties properties) {
        this.properties = properties;
    }

    public String getDisplayName() {
        return this.owner + ".crop." + this.name;
    }

    @ZenGetter(value="tier")
    public int tier() {
        return this.tier;
    }

    @ZenGetter(value="attributes")
    public String[] getAttributes() {
        return this.attributes;
    }

    @ZenSetter(value="attributes")
    public void setAttributes(String[] attributes) {
        this.attributes = attributes;
    }

    @ZenGetter(value="maxSize")
    public int getMaxSize() {
        return this.maxSize;
    }

    @ZenSetter(value="maxSize")
    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }

    public boolean canGrow(ICropTile crop) {
        if (crop.getCurrentSize() == this.maxSize) {
            return false;
        }
        if (this.reqs == null) {
            return true;
        }
        if (!crop.isBlockBelow(MineTweakerMC.getBlock(this.reqs.getRequiredBlock()))) {
            return false;
        }
        if (crop.getAirQuality() < this.reqs.getMinAirQuality()) {
            return false;
        }
        if (crop.getHumidity() < this.reqs.getMinHumidity()) {
            return false;
        }
        if (crop.getNutrients() < this.reqs.getMinNutrients()) {
            return false;
        }
        int lgh = crop.getLightLevel();
        return this.reqs.getMinLight() < lgh && this.reqs.getMaxLight() > lgh;
    }

    public boolean canBeHarvested(ICropTile crop) {
        return crop.getCurrentSize() == this.maxSize;
    }

    public ItemStack getGain(ICropTile crop) {
        return MineTweakerMC.getItemStack(this.fruit);
    }

    @ZenGetter(value="dropChance")
    public double dropGainChance() {
        return this.dropChance;
    }

    @ZenSetter(value="tier")
    public void setTier(int tier) {
        this.tier = tier;
    }

    @ZenSetter(value="stats")
    public void setStats(int[] stats) {
        this.stats = stats;
    }

    @ZenMethod
    public void setStat(int stat, int val) {
        if (stat < 0 || stat > 3) {
            MineTweakerAPI.logWarning("invalid stat index " + stat);
        } else {
            this.stats[stat] = val;
        }
    }

    @ZenSetter(value="fruit")
    public void setFruit(IItemStack fruit) {
        this.fruit = fruit;
    }

    @ZenSetter(value="dropChance")
    public void setDropChance(int dropChance) {
        this.dropChance = dropChance;
    }

    public GrowthRequirements getReqs() {
        return this.reqs;
    }

    public void setReqs(GrowthRequirements reqs) {
        this.reqs = reqs;
    }
}

