/*
 * Decompiled with CFR 0.152.
 */
package minetweaker.mods.ic2.machines;

import ic2.api.recipe.IRecipeInput;
import ic2.api.recipe.RecipeInputFluidContainer;
import ic2.api.recipe.Recipes;
import minetweaker.MineTweakerAPI;
import minetweaker.OneWayAction;
import minetweaker.annotations.ModOnly;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import minetweaker.api.liquid.ILiquidStack;
import minetweaker.api.minecraft.MineTweakerMC;
import minetweaker.mods.ic2.IC2RecipeInput;
import net.minecraftforge.fluids.FluidStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.ic2.Canner")
@ModOnly(value={"IC2"})
public class Canner {
    @ZenMethod
    public static void addBottleRecipe(IItemStack output, IIngredient container, IIngredient fill) {
        MineTweakerAPI.apply(new AddBottleIngredientAction(container, fill, output));
    }

    @ZenMethod
    public static void addBottleRecipe(IItemStack output, IIngredient container, ILiquidStack liquid) {
        MineTweakerAPI.apply(new AddBottleLiquidAction(container, liquid, output));
    }

    @ZenMethod
    public static void addEnrichRecipe(ILiquidStack output, ILiquidStack input, IIngredient additive) {
        MineTweakerAPI.apply(new AddEnrichIngredientAction(input, additive, output));
    }

    @ZenMethod
    public static void addEnrichRecipe(ILiquidStack output, ILiquidStack input, ILiquidStack additive) {
        MineTweakerAPI.apply(new AddEnrichLiquidAction(input, additive, output));
    }

    private static class AddEnrichLiquidAction
    extends OneWayAction {
        private final ILiquidStack input;
        private final ILiquidStack additive;
        private final ILiquidStack output;

        public AddEnrichLiquidAction(ILiquidStack input, ILiquidStack additive, ILiquidStack output) {
            this.input = input;
            this.additive = additive;
            this.output = output;
        }

        @Override
        public void apply() {
            Recipes.cannerEnrich.addRecipe((FluidStack)this.input.getInternal(), (IRecipeInput)new RecipeInputFluidContainer(((FluidStack)this.additive.getInternal()).getFluid(), this.additive.getAmount()), (FluidStack)this.output.getInternal());
        }

        @Override
        public String describe() {
            return "Adding canner enrich recipe " + this.input + " + " + this.additive + " => " + this.output;
        }

        @Override
        public Object getOverrideKey() {
            return null;
        }

        public int hashCode() {
            int hash = 7;
            hash = 19 * hash + (this.input != null ? this.input.hashCode() : 0);
            hash = 19 * hash + (this.additive != null ? this.additive.hashCode() : 0);
            hash = 19 * hash + (this.output != null ? this.output.hashCode() : 0);
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AddEnrichLiquidAction other = (AddEnrichLiquidAction)obj;
            return (this.input == other.input || this.input != null && this.input.equals(other.input)) && (this.additive == other.additive || this.additive != null && this.additive.equals(other.additive)) && (this.output == other.output || this.output != null && this.output.equals(other.output));
        }
    }

    private static class AddEnrichIngredientAction
    extends OneWayAction {
        private final ILiquidStack input;
        private final IIngredient additive;
        private final ILiquidStack output;

        public AddEnrichIngredientAction(ILiquidStack input, IIngredient additive, ILiquidStack output) {
            this.input = input;
            this.additive = additive;
            this.output = output;
        }

        @Override
        public void apply() {
            Recipes.cannerEnrich.addRecipe((FluidStack)this.input.getInternal(), (IRecipeInput)new IC2RecipeInput(this.additive), (FluidStack)this.output.getInternal());
        }

        @Override
        public String describe() {
            return "Adding canner enrich recipe " + this.input + " + " + this.additive + " => " + this.output;
        }

        @Override
        public Object getOverrideKey() {
            return null;
        }

        public int hashCode() {
            int hash = 7;
            hash = 47 * hash + (this.input != null ? this.input.hashCode() : 0);
            hash = 47 * hash + (this.additive != null ? this.additive.hashCode() : 0);
            hash = 47 * hash + (this.output != null ? this.output.hashCode() : 0);
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AddEnrichIngredientAction other = (AddEnrichIngredientAction)obj;
            return (this.input == other.input || this.input != null && this.input.equals(other.input)) && (this.additive == other.additive || this.additive != null && this.additive.equals(other.additive)) && (this.output == other.output || this.output != null && this.output.equals(other.output));
        }
    }

    private static class AddBottleLiquidAction
    extends OneWayAction {
        private final IIngredient container;
        private final ILiquidStack fill;
        private final IItemStack output;

        public AddBottleLiquidAction(IIngredient container, ILiquidStack fill, IItemStack output) {
            this.container = container;
            this.fill = fill;
            this.output = output;
        }

        @Override
        public void apply() {
            Recipes.cannerBottle.addRecipe((IRecipeInput)new IC2RecipeInput(this.container), (IRecipeInput)new RecipeInputFluidContainer(((FluidStack)this.fill.getInternal()).getFluid(), this.fill.getAmount()), MineTweakerMC.getItemStack(this.output));
        }

        @Override
        public String describe() {
            return "Adding cannor bottle recipe " + this.container + " + " + this.fill + " => " + this.output;
        }

        @Override
        public Object getOverrideKey() {
            return null;
        }
    }

    private static class AddBottleIngredientAction
    extends OneWayAction {
        private final IIngredient container;
        private final IIngredient fill;
        private final IItemStack output;

        public AddBottleIngredientAction(IIngredient container, IIngredient fill, IItemStack output) {
            this.container = container;
            this.fill = fill;
            this.output = output;
        }

        @Override
        public void apply() {
            Recipes.cannerBottle.addRecipe((IRecipeInput)new IC2RecipeInput(this.container), (IRecipeInput)new IC2RecipeInput(this.fill), MineTweakerMC.getItemStack(this.output));
        }

        @Override
        public String describe() {
            return "Adding canner bottle recipe " + this.container + " + " + this.fill + " => " + this.output;
        }

        @Override
        public Object getOverrideKey() {
            return null;
        }

        public int hashCode() {
            int hash = 7;
            hash = 67 * hash + (this.container != null ? this.container.hashCode() : 0);
            hash = 67 * hash + (this.fill != null ? this.fill.hashCode() : 0);
            hash = 67 * hash + (this.output != null ? this.output.hashCode() : 0);
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AddBottleIngredientAction other = (AddBottleIngredientAction)obj;
            return (this.container == other.container || this.container != null && this.container.equals(other.container)) && (this.fill == other.fill || this.fill != null && this.fill.equals(other.fill)) && (this.output == other.output || this.output != null && this.output.equals(other.output));
        }
    }
}

