/*
 * Decompiled with CFR 0.152.
 */
package minetweaker.mc1112;

import java.io.File;
import java.util.ArrayList;
import minetweaker.MineTweakerAPI;
import minetweaker.MineTweakerImplementationAPI;
import minetweaker.api.item.IItemStack;
import minetweaker.api.minecraft.MineTweakerMC;
import minetweaker.mc1112.FMLEventHandler;
import minetweaker.mc1112.ForgeEventHandler;
import minetweaker.mc1112.MCPlatformFunctions;
import minetweaker.mc1112.MineTweakerRegistry;
import minetweaker.mc1112.brackets.EntityBracketHandler;
import minetweaker.mc1112.brackets.ItemBracketHandler;
import minetweaker.mc1112.brackets.LiquidBracketHandler;
import minetweaker.mc1112.brackets.OreBracketHandler;
import minetweaker.mc1112.client.MCClient;
import minetweaker.mc1112.formatting.MCFormatter;
import minetweaker.mc1112.furnace.FuelTweaker;
import minetweaker.mc1112.furnace.MCFurnaceManager;
import minetweaker.mc1112.game.MCGame;
import minetweaker.mc1112.logger.MCLogger;
import minetweaker.mc1112.mods.MCLoadedMods;
import minetweaker.mc1112.network.MineTweakerCopyClipboardHandler;
import minetweaker.mc1112.network.MineTweakerCopyClipboardPacket;
import minetweaker.mc1112.network.MineTweakerLoadScriptsHandler;
import minetweaker.mc1112.network.MineTweakerLoadScriptsPacket;
import minetweaker.mc1112.network.MineTweakerOpenBrowserHandler;
import minetweaker.mc1112.network.MineTweakerOpenBrowserPacket;
import minetweaker.mc1112.oredict.MCOreDict;
import minetweaker.mc1112.recipes.MCRecipeManager;
import minetweaker.mc1112.server.MCServer;
import minetweaker.mc1112.util.MineTweakerHacks;
import minetweaker.mc1112.util.MineTweakerPlatformUtils;
import minetweaker.mc1112.vanilla.MCVanilla;
import minetweaker.runtime.GlobalRegistry;
import minetweaker.runtime.IScriptProvider;
import minetweaker.runtime.providers.ScriptProviderCascade;
import minetweaker.runtime.providers.ScriptProviderCustom;
import minetweaker.runtime.providers.ScriptProviderDirectory;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLLoadCompleteEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppedEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;

@Mod(modid="crafttweaker", version="3.1.0", name="Crafttweaker", dependencies="after:jei@[4.5.0.287,)", acceptedMinecraftVersions="[1.11.2]")
public class MineTweakerMod {
    public static final String MODID = "crafttweaker";
    public static final String NAME = "Crafttweaker";
    public static final String MCVERSION = "1.11.2";
    public static final SimpleNetworkWrapper NETWORK = NetworkRegistry.INSTANCE.newSimpleChannel("crafttweaker");
    private static final String[] REGISTRIES = new String[]{"minetweaker.mods.jei.ClassRegistry"};
    private static final String[] REGISTRY_DESCRIPTIONS = new String[]{"JEI mod support"};
    public static MinecraftServer server;
    @Mod.Instance(value="crafttweaker")
    public static MineTweakerMod INSTANCE;
    public final MCRecipeManager recipes = new MCRecipeManager();
    private final IScriptProvider scriptsGlobal;
    private final ScriptProviderCustom scriptsIMC;

    public MineTweakerMod() {
        MineTweakerImplementationAPI.init(new MCOreDict(), this.recipes, new MCFurnaceManager(), MCGame.INSTANCE, new MCLoadedMods(), new MCFormatter(), new MCVanilla());
        MineTweakerImplementationAPI.logger.addLogger(new MCLogger(new File("minetweaker.log")));
        MineTweakerImplementationAPI.platform = MCPlatformFunctions.INSTANCE;
        File globalDir = new File("scripts");
        if (!globalDir.exists()) {
            globalDir.mkdirs();
        }
        this.scriptsIMC = new ScriptProviderCustom("intermod");
        this.scriptsGlobal = new ScriptProviderDirectory(globalDir);
        MineTweakerImplementationAPI.setScriptProvider(this.scriptsGlobal);
    }

    @Mod.EventHandler
    public void onIMCEvent(FMLInterModComms.IMCEvent event) {
        event.getMessages().stream().filter(imcMessage -> imcMessage.key.equalsIgnoreCase("addMineTweakerScript")).forEach(imcMessage -> {
            if (imcMessage.isStringMessage()) {
                this.scriptsIMC.add(imcMessage.getSender() + "::imc", imcMessage.getStringValue());
            } else if (imcMessage.isNBTMessage()) {
                NBTTagCompound message = imcMessage.getNBTValue();
                this.scriptsIMC.add(imcMessage.getSender() + "::" + message.func_74779_i("name"), message.func_74779_i("content"));
            }
        });
    }

    @Mod.EventHandler
    public void onLoad(FMLPreInitializationEvent ev) {
        MinecraftForge.EVENT_BUS.register((Object)new ForgeEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new FMLEventHandler());
    }

    @Mod.EventHandler
    public void onPostInit(FMLPostInitializationEvent ev) {
        MineTweakerAPI.registerClassRegistry(MineTweakerRegistry.class);
        for (int i = 0; i < REGISTRIES.length; ++i) {
            MineTweakerAPI.registerClassRegistry(REGISTRIES[i], REGISTRY_DESCRIPTIONS[i]);
        }
        FuelTweaker.INSTANCE.register();
    }

    @Mod.EventHandler
    public void onComplete(FMLLoadCompleteEvent ev) {
        MineTweakerAPI.logInfo("MineTweaker: Building registry");
        ItemBracketHandler.rebuildItemRegistry();
        LiquidBracketHandler.rebuildLiquidRegistry();
        EntityBracketHandler.rebuildEntityRegistry();
        MineTweakerAPI.logInfo("MineTweaker: Sucessfully built item registry");
        GlobalRegistry.registerBracketHandler(new ItemBracketHandler());
        GlobalRegistry.registerBracketHandler(new LiquidBracketHandler());
        GlobalRegistry.registerBracketHandler(new OreBracketHandler());
        GlobalRegistry.registerBracketHandler(new EntityBracketHandler());
    }

    @Mod.EventHandler
    public void onServerAboutToStart(FMLServerAboutToStartEvent ev) {
        server = ev.getServer();
    }

    @Mod.EventHandler
    public void onServerStarting(FMLServerStartingEvent ev) {
        File scriptsDir;
        server = ev.getServer();
        MineTweakerImplementationAPI.addMineTweakerCommand("itemrecipes", new String[]{"Logs items that have a crafting table recipe"}, (arguments, player) -> {
            ArrayList<IItemStack> stacks = new ArrayList<IItemStack>();
            for (IRecipe recipe : CraftingManager.func_77594_a().func_77592_b()) {
                stacks.add(MineTweakerMC.getIItemStack(recipe.func_77571_b()));
            }
            for (IItemStack stack : stacks) {
                if (stack == null) continue;
                MineTweakerAPI.logCommand(stack.toString());
            }
            player.sendChat("Recipe list generated; see minetweaker.log in your minecraft dir");
        });
        if (MineTweakerPlatformUtils.isClient()) {
            MineTweakerAPI.client = new MCClient();
        }
        if (!(scriptsDir = new File(MineTweakerHacks.getWorldDirectory(ev.getServer()), "scripts")).exists()) {
            scriptsDir.mkdir();
        }
        ScriptProviderDirectory scriptsLocal = new ScriptProviderDirectory(scriptsDir);
        ScriptProviderCascade cascaded = new ScriptProviderCascade(this.scriptsIMC, this.scriptsGlobal, scriptsLocal);
        MineTweakerImplementationAPI.setScriptProvider(cascaded);
        MineTweakerImplementationAPI.onServerStart(new MCServer(ev.getServer()));
    }

    @Mod.EventHandler
    public void onServerStopped(FMLServerStoppedEvent ev) {
        MineTweakerImplementationAPI.onServerStop();
        MineTweakerImplementationAPI.setScriptProvider(this.scriptsGlobal);
        MineTweakerAPI.logInfo("Server stopping, Scripts are being rolled back!");
        server = null;
    }

    static {
        NETWORK.registerMessage(MineTweakerLoadScriptsHandler.class, MineTweakerLoadScriptsPacket.class, 0, Side.CLIENT);
        NETWORK.registerMessage(MineTweakerOpenBrowserHandler.class, MineTweakerOpenBrowserPacket.class, 1, Side.CLIENT);
        NETWORK.registerMessage(MineTweakerCopyClipboardHandler.class, MineTweakerCopyClipboardPacket.class, 2, Side.CLIENT);
    }
}

