/*
 * Decompiled with CFR 0.152.
 */
package minetweaker.mc1112.actions;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IItemStack;
import minetweaker.mc1112.util.MineTweakerHacks;
import net.minecraft.util.text.translation.LanguageMap;

public class SetTranslationAction
implements IUndoableAction {
    private static final LanguageMap INSTANCE = MineTweakerHacks.getStringTranslateInstance();
    private static final Charset UTF8 = Charset.forName("utf-8");
    private final IItemStack stack;
    private final String key;
    private final String newValue;
    private final String oldValue;

    public SetTranslationAction(IItemStack stack, String key, String value) {
        this.stack = stack;
        this.key = key;
        this.newValue = value;
        this.oldValue = INSTANCE.func_74805_b(key);
    }

    private static void set(IItemStack stack, String key, String value) {
        if (value.contains("\\\"")) {
            value = value.replace("\\\"", "\"");
        }
        MineTweakerAPI.getIjeiRecipeRegistry().removeItem(stack.getInternal());
        LanguageMap.inject((InputStream)new ByteArrayInputStream((key + "=" + value).getBytes(UTF8)));
        MineTweakerAPI.getIjeiRecipeRegistry().addItem(stack.getInternal());
    }

    @Override
    public void apply() {
        SetTranslationAction.set(this.stack, this.key, this.newValue);
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public void undo() {
        SetTranslationAction.set(this.stack, this.key, this.oldValue);
    }

    @Override
    public String describe() {
        return "Translating " + this.key + " to " + this.newValue;
    }

    @Override
    public String describeUndo() {
        return "Reverting " + this.key + " to " + this.oldValue;
    }

    @Override
    public Object getOverrideKey() {
        return null;
    }
}

